/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.security.TokenGenerator;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.IStreamRepository;
import ch.systemsx.cisd.openbis.dss.generic.server.InputStreamWithPath;
import ch.systemsx.cisd.openbis.dss.generic.shared.IConfigProvider;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StreamRepository
implements IStreamRepository {
    private final Map<String, InputStreamWithValidityDuration> streams = new HashMap<String, InputStreamWithValidityDuration>();
    private final IUniqueIdGenerator inputStreamIDGenerator;
    private final ITimeProvider timeProvider;
    private final long minimumTime;
    private final long maximumTime;

    public StreamRepository(IConfigProvider configProvider) {
        this(configProvider.getDataStreamTimeout(), configProvider.getDataStreamMaxTimeout(), new IdGenerator(), SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    @Private
    StreamRepository(int minimumTimeInSecondsToKeepStreams, int maximumTimeInSecondsToKeepStreams, IUniqueIdGenerator inputStreamIDGenerator, ITimeProvider timeProvider) {
        if (minimumTimeInSecondsToKeepStreams <= 0) {
            throw new IllegalArgumentException("Minimum time to keep streams is not a positive number: " + minimumTimeInSecondsToKeepStreams);
        }
        this.minimumTime = (long)minimumTimeInSecondsToKeepStreams * 1000L;
        if (maximumTimeInSecondsToKeepStreams <= 0) {
            throw new IllegalArgumentException("Maximum time to keep streams is not a positive number: " + maximumTimeInSecondsToKeepStreams);
        }
        this.maximumTime = (long)maximumTimeInSecondsToKeepStreams * 1000L;
        this.inputStreamIDGenerator = inputStreamIDGenerator;
        this.timeProvider = timeProvider;
    }

    @Override
    public synchronized String addStream(InputStream inputStream, String path, long validityInSeconds) {
        this.removeStaleInputStreams();
        String id = this.inputStreamIDGenerator.createUniqueID();
        Date timestamp = new Date(this.timeProvider.getTimeInMilliseconds());
        long validityInMs = validityInSeconds * 1000L;
        long validity = validityInMs < this.minimumTime ? this.minimumTime : validityInMs;
        validity = validityInMs > this.maximumTime ? this.maximumTime : validity;
        this.streams.put(id, new InputStreamWithValidityDuration(new InputStreamWithPath(inputStream, path), timestamp, validity));
        return id;
    }

    @Override
    public synchronized InputStreamWithPath getStream(String inputStreamID) {
        this.removeStaleInputStreams();
        InputStreamWithValidityDuration inputStreamWithTimeStamp = this.streams.remove(inputStreamID);
        if (inputStreamWithTimeStamp == null) {
            throw new IllegalArgumentException("Stream " + inputStreamID + " is no longer available.");
        }
        return inputStreamWithTimeStamp.inputStreamWithPath;
    }

    private void removeStaleInputStreams() {
        long currentTime = this.timeProvider.getTimeInMilliseconds();
        Set<Map.Entry<String, InputStreamWithValidityDuration>> entrySet = this.streams.entrySet();
        Iterator<Map.Entry<String, InputStreamWithValidityDuration>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            InputStreamWithValidityDuration stream = iterator.next().getValue();
            if (stream.timestamp.getTime() >= currentTime - stream.validityInMs) continue;
            iterator.remove();
        }
    }

    static interface IUniqueIdGenerator {
        public String createUniqueID();
    }

    private static final class IdGenerator
    implements IUniqueIdGenerator {
        private final TokenGenerator tokenGenerator = new TokenGenerator();

        private IdGenerator() {
        }

        @Override
        public String createUniqueID() {
            return this.tokenGenerator.getNewToken(System.currentTimeMillis());
        }
    }

    private static final class InputStreamWithValidityDuration {
        final long validityInMs;
        final Date timestamp;
        final InputStreamWithPath inputStreamWithPath;

        InputStreamWithValidityDuration(InputStreamWithPath inputStreamWithPath, Date timestamp, long validityDuration) {
            this.inputStreamWithPath = inputStreamWithPath;
            this.timestamp = timestamp;
            this.validityInMs = validityDuration;
        }
    }
}

