/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDatastorePlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingTransformerDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageEnrichedDTO;
import java.io.File;
import java.util.List;
import java.util.Properties;

public abstract class AbstractSpotImagesTransformerProcessingPlugin
extends AbstractDatastorePlugin
implements IProcessingPluginTask {
    protected static final IImageTransformerFactoryProvider NO_TRANSFORMATION_PROVIDER = new IImageTransformerFactoryProvider(){

        @Override
        public IImageTransformerFactory tryGetTransformationFactory(ImgImageEnrichedDTO image) {
            return null;
        }
    };
    private static final long serialVersionUID = 1L;
    private static final String CHANNEL_CODE_PROPERTY = "channel";
    private static IImagingReadonlyQueryDAO query;
    private final String channelCode;

    protected abstract IImageTransformerFactoryProvider getTransformationProvider(List<ImgImageEnrichedDTO> var1, IHierarchicalContent var2);

    public AbstractSpotImagesTransformerProcessingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.channelCode = PropertyUtils.getMandatoryProperty(properties, CHANNEL_CODE_PROPERTY);
    }

    @Override
    public ProcessingStatus process(List<DatasetDescription> dataSets, DataSetProcessingContext context) {
        IImagingTransformerDAO transformerDAO = DssScreeningUtils.createImagingTransformerDAO();
        try {
            ProcessingStatus processingStatus = new ProcessingStatus();
            for (DatasetDescription dataSet : dataSets) {
                IHierarchicalContent hierarchicalContent = this.createHierarchicalContent(context, dataSet);
                GroupByMap<Long, ImgImageEnrichedDTO> imagesBySpot = this.fetchImages(dataSet);
                for (Long spotId : imagesBySpot.getKeys()) {
                    List<ImgImageEnrichedDTO> spotImages = imagesBySpot.tryGet(spotId);
                    this.calculateAndSetImageTransformation(spotImages, hierarchicalContent, transformerDAO);
                }
                transformerDAO.commit();
                processingStatus.addDatasetStatus(dataSet, Status.OK);
            }
            ProcessingStatus processingStatus2 = processingStatus;
            return processingStatus2;
        }
        finally {
            transformerDAO.close(true);
        }
    }

    private static IImagingReadonlyQueryDAO getQuery() {
        if (query == null) {
            query = DssScreeningUtils.getQuery();
        }
        return query;
    }

    private void calculateAndSetImageTransformation(List<ImgImageEnrichedDTO> spotImages, IHierarchicalContent hierarchicalContent, IImagingTransformerDAO transformerDAO) {
        long start = System.currentTimeMillis();
        IImageTransformerFactoryProvider transformerFactoryProvider = this.getTransformationProvider(spotImages, hierarchicalContent);
        for (ImgImageEnrichedDTO image : spotImages) {
            IImageTransformerFactory transformationFactory = transformerFactoryProvider.tryGetTransformationFactory(image);
            transformerDAO.saveTransformerFactoryForImage(image.getAcquiredImageId(), transformationFactory);
        }
        operationLog.info((Object)String.format("Processed %d images of the spot in %d msec.", spotImages.size(), System.currentTimeMillis() - start));
    }

    private IHierarchicalContent createHierarchicalContent(DataSetProcessingContext context, DatasetDescription dataSet) {
        return context.getHierarchicalContentProvider().asContent(dataSet.getDataSetCode());
    }

    private GroupByMap<Long, ImgImageEnrichedDTO> fetchImages(DatasetDescription dataset) {
        List<ImgImageEnrichedDTO> allImages = AbstractSpotImagesTransformerProcessingPlugin.getQuery().listHCSImages(dataset.getDataSetCode(), this.channelCode);
        GroupByMap<Long, ImgImageEnrichedDTO> imagesBySpot = GroupByMap.create(allImages, new IGroupKeyExtractor<Long, ImgImageEnrichedDTO>(){

            @Override
            public Long getKey(ImgImageEnrichedDTO image) {
                return image.getSpotId();
            }
        });
        if (allImages.size() == 0) {
            operationLog.warn((Object)String.format("Dataset %s has no images for channel '%s' to process! Have you specified the correct channel code?", dataset.getDataSetCode(), this.channelCode));
        } else {
            operationLog.info((Object)String.format("Dataset %s has %d images (devided between %d spots) for channel '%s' to process.", dataset.getDataSetCode(), allImages.size(), imagesBySpot.getKeys().size(), this.channelCode));
        }
        return imagesBySpot;
    }

    static interface IImageTransformerFactoryProvider {
        public IImageTransformerFactory tryGetTransformationFactory(ImgImageEnrichedDTO var1);
    }
}

