/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.SimpleShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.SpeedChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.List;
import java.util.Properties;

public class SpeedOptimizedShareFinder
implements IShareFinder {
    private final SimpleShareFinder simpleFinder;

    public SpeedOptimizedShareFinder(Properties properties) {
        this.simpleFinder = new SimpleShareFinder(properties);
    }

    @Override
    public Share tryToFindShare(SimpleDataSetInformationDTO dataSet, List<Share> shares) {
        Share share = this.tryToFindExtensionShare(dataSet, shares, SpeedChecker.MATCHING_CHECKER);
        if (share != null) {
            return share;
        }
        share = this.tryToFindExtensionShare(dataSet, shares, SpeedChecker.RESPECTING_SPEED_HINT_CHECKER);
        if (share != null) {
            return share;
        }
        return this.simpleFinder.tryToFindShare(dataSet, shares, SpeedChecker.IGNORING_SPEED_HINT_CHECKER);
    }

    private Share tryToFindExtensionShare(SimpleDataSetInformationDTO dataSet, List<Share> shares, ISpeedChecker speedChecker) {
        Share result = null;
        long maxFreeSpace = dataSet.getDataSetSize();
        for (Share share : shares) {
            long freeSpace;
            if (share.isIncoming() || !speedChecker.check(dataSet, share) || (freeSpace = share.calculateFreeSpace()) <= maxFreeSpace) continue;
            maxFreeSpace = freeSpace;
            result = share;
        }
        return result;
    }
}

