/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.openbis.generic.client.console.ICommand;
import ch.systemsx.cisd.openbis.generic.client.console.RegisterDataSetType;
import ch.systemsx.cisd.openbis.generic.client.console.RegisterExperimentType;
import ch.systemsx.cisd.openbis.generic.client.console.RegisterMaterialType;
import ch.systemsx.cisd.openbis.generic.client.console.RegisterSampleType;
import ch.systemsx.cisd.openbis.generic.client.console.ScriptContext;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import java.util.HashMap;
import java.util.Map;

class RegisterType
implements ICommand {
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();

    RegisterType() {
        this.commands.put("EXPERIMENT", new RegisterExperimentType());
        this.commands.put("SAMPLE", new RegisterSampleType());
        this.commands.put("DATA_SET", new RegisterDataSetType());
        this.commands.put("MATERIAL", new RegisterMaterialType());
    }

    @Override
    public void execute(ICommonServer server, String sessionToken, ScriptContext context, String argument) {
        int indexOfSpace = argument.indexOf(32);
        String command = indexOfSpace < 0 ? argument : argument.substring(0, indexOfSpace);
        ICommand cmd = this.commands.get(command);
        if (cmd == null) {
            throw new IllegalArgumentException("Unkown register command: " + command);
        }
        cmd.execute(server, sessionToken, null, indexOfSpace < 0 ? "" : argument.substring(indexOfSpace).trim());
    }
}

