/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AttachmentVersionsSection;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ProjectPropertiesPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BorderLayoutDataFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.ProjectGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.ProjectListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;

public final class ProjectViewer
extends AbstractViewer<IEntityInformationHolder>
implements IDatabaseModificationObserver {
    private static final String PREFIX = "project-viewer_";
    public static final String ID_PREFIX = "openbis_project-viewer_";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final TechId projectId;
    private Project originalProject;

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, TechId projectId) {
        ProjectViewer viewer = new ProjectViewer(viewContext, projectId);
        return new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
    }

    private ProjectViewer(IViewContext<ICommonClientServiceAsync> viewContext, TechId projectId) {
        super(viewContext, ProjectViewer.createId(projectId));
        this.projectId = projectId;
        this.viewContext = viewContext;
        this.setLayout((Layout)new BorderLayout());
        this.extendToolBar();
        this.reloadAllData();
    }

    private void extendToolBar() {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addToolBarButton(this.createDeleteButton(new IDelegatedAction(){

            @Override
            public void execute() {
                new ProjectListDeletionConfirmationDialog((IViewContext<ICommonClientServiceAsync>)ProjectViewer.this.viewContext, ProjectViewer.this.originalProject, (AbstractAsyncCallback<Void>)ProjectViewer.this.createPermanentDeletionCallback()).show();
            }
        }));
    }

    @Override
    protected void reloadAllData() {
        this.reloadData(new ProjectInfoCallback(this.viewContext, this));
    }

    public static String createId(TechId projectId) {
        return ID_PREFIX + projectId;
    }

    protected void reloadData(AbstractAsyncCallback<Project> callback) {
        this.viewContext.getService().getProjectInfo(this.projectId, callback);
    }

    private TabContent createAttachmentsSection(Project project) {
        return new AttachmentVersionsSection(this.viewContext.getCommonViewContext(), project);
    }

    private void recreateView(Project project) {
        this.updateOriginalProject(project);
        this.removeAll();
        Component topPanel = this.createTopPanel(project);
        this.add((Widget)topPanel, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.NORTH, 150.0f));
        Component centerPanel = this.createCenterPanel(project);
        this.add((Widget)centerPanel, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.CENTER));
        this.layout();
    }

    private void updateOriginalProject(Project result) {
        this.originalProject = result;
        this.updateBreadcrumbs();
        this.setToolBarButtonsEnabled(true);
    }

    @Override
    public void setupRemovedEntityView() {
        this.removeAll();
        this.updateTitle(String.valueOf(this.getOriginalDataDescription()) + " does not exist any more.");
        this.setToolBarButtonsEnabled(false);
    }

    public Component createCenterPanel(Project result) {
        TabContent panel = this.createAttachmentsSection(result);
        panel.setContentVisible(true);
        return panel;
    }

    public Component createTopPanel(Project result) {
        ProjectPropertiesPanel panel = new ProjectPropertiesPanel(result, this.viewContext);
        panel.setScrollMode(Style.Scroll.AUTOY);
        return panel;
    }

    @Override
    protected String getOriginalDataDescription() {
        return String.valueOf(this.viewContext.getMessage("project", new Object[0])) + " " + this.originalProject.getIdentifier();
    }

    @Override
    protected void showEntityEditor(boolean inBackground) {
        assert (this.originalProject != null);
        ProjectGrid.showEntityViewer(this.originalProject, true, this.viewContext, inBackground);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.reloadAllData();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROJECT);
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_project", new Object[0]);
    }

    private static final class ProjectInfoCallback
    extends AbstractAsyncCallback<Project> {
        private final ProjectViewer viewer;

        private ProjectInfoCallback(IViewContext<ICommonClientServiceAsync> viewContext, ProjectViewer viewer) {
            super(viewContext);
            this.viewer = viewer;
        }

        @Override
        protected final void process(Project result) {
            this.viewer.recreateView(result);
        }

        @Override
        public void finishOnFailure(Throwable caught) {
            this.viewer.setupRemovedEntityView();
        }
    }
}

