/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.menu;

import ch.systemsx.cisd.openbis.generic.client.web.client.IClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ITabActionMenuItemDefinition;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;

public class TabActionMenuItemFactory {
    public static <S extends IClientServiceAsync> ActionMenu createActionMenu(final IViewContext<S> viewContext, final String widgetIDPrefix, final ITabActionMenuItemDefinition<S> definition) {
        IActionMenuItem menuItem = new IActionMenuItem(){

            @Override
            public String getMenuId() {
                return String.valueOf(widgetIDPrefix) + "_" + definition.getName();
            }

            @Override
            public String getMenuText(IMessageProvider messageProvider) {
                return messageProvider.getMessage(String.valueOf(definition.getName()) + "_menu_item", new Object[0]);
            }
        };
        final String tabLabelKey = String.valueOf(definition.getName()) + "_tab_label";
        return new ActionMenu(menuItem, viewContext, new AbstractTabItemFactory(){

            @Override
            public String getId() {
                return String.valueOf(widgetIDPrefix) + "_" + tabLabelKey;
            }

            @Override
            public ITabItem create() {
                return DefaultTabItem.create(this.getTabTitle(), definition.createComponent(viewContext), viewContext, false);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific(definition.getHelpPageTitle());
            }

            @Override
            public String getTabTitle() {
                return viewContext.getMessage(tabLabelKey, new Object[0]);
            }

            @Override
            public String tryGetLink() {
                return definition.tryGetLink();
            }
        });
    }
}

