/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BasicLoginCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Widget;

public class LoginPanelAutofill
extends VerticalPanel {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final FormPanel formPanel;
    private static final String PREFIX = "login_";
    private static final String ID_PREFIX = "openbis_login_";
    private static final String LOGIN_FORM_ID = "openbis_login_form";
    public static final String USERNAME_ID = "openbis_login_username";
    public static final String PASSWORD_ID = "openbis_login_password";
    public static final String SUBMIT_ID = "openbis_login_submit";
    private static LoginPanelAutofill singleton = null;

    public static LoginPanelAutofill get(IViewContext<ICommonClientServiceAsync> viewContext) {
        if (singleton == null) {
            singleton = new LoginPanelAutofill(viewContext);
        }
        return singleton;
    }

    private LoginPanelAutofill(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
        this.setSpacing(10);
        this.setBorders(false);
        this.add((Component)new Text(viewContext.getMessage("login_invitation", new Object[0])));
        Element formElement = Document.get().getElementById(LOGIN_FORM_ID);
        if (formElement == null) {
            this.formPanel = null;
            return;
        }
        this.formPanel = FormPanel.wrap((Element)formElement, (boolean)false);
        this.formPanel.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                if (!LoginPanelAutofill.this.isUserInputValid()) {
                    event.cancel();
                } else {
                    LoginPanelAutofill.this.doLogin();
                }
            }
        });
        this.add((Widget)this.formPanel);
    }

    private final boolean isUserInputValid() {
        if (GWTUtils.isTesting()) {
            return true;
        }
        String username = this.getUsernameElement().getValue();
        String password = this.getPasswordElement().getValue();
        if (username == null || username.trim().length() == 0) {
            return false;
        }
        return password != null && password.trim().length() != 0;
    }

    private void giveFocusToFirstField() {
        this.getUsernameElement().focus();
    }

    protected final void onLoad() {
        super.onLoad();
        if (GWTUtils.isTesting()) {
            return;
        }
        this.getButtonElement().setDisabled(false);
        this.giveFocusToFirstField();
    }

    private final void doLogin() {
        this.getButtonElement().setDisabled(true);
        InputElement usernameElement = this.getUsernameElement();
        InputElement passwordElement = this.getPasswordElement();
        String user = usernameElement.getValue();
        String password = passwordElement.getValue();
        this.viewContext.getService().tryToLogin(user, password, new LoginCallback(this.viewContext));
    }

    public InputElement getPasswordElement() {
        return InputElement.as((Element)Document.get().getElementById(PASSWORD_ID));
    }

    public InputElement getUsernameElement() {
        return InputElement.as((Element)Document.get().getElementById(USERNAME_ID));
    }

    public final InputElement getButtonElement() {
        return InputElement.as((Element)Document.get().getElementById(SUBMIT_ID));
    }

    public final class LoginCallback
    extends BasicLoginCallback {
        private LoginCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext, "login_failed");
        }

        @Override
        public final void finishOnFailure(Throwable caught) {
            LoginPanelAutofill.this.getPasswordElement().setValue(LoginPanelAutofill.this.getPasswordElement().getDefaultValue());
            LoginPanelAutofill.this.getButtonElement().setDisabled(false);
        }

        @Override
        protected void cleanup() {
            LoginPanelAutofill.this.getPasswordElement().setValue(LoginPanelAutofill.this.getPasswordElement().getDefaultValue());
        }
    }
}

