/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.TabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SectionsPanel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import java.util.Collection;
import java.util.List;

public class ModulesSectionsManager {
    private SectionsPanel container;
    private IEntityInformationHolderWithIdentifier entity;
    private List<IModule> modules;

    public void initialize(SectionsPanel container, IEntityInformationHolderWithIdentifier entity) {
        this.container = container;
        this.entity = entity;
        if (this.modules != null) {
            this.attachModulesSections();
        }
    }

    public void initialize(List<IModule> modules) {
        this.modules = modules;
        if (this.container != null) {
            this.attachModulesSections();
        }
    }

    private void attachModulesSections() {
        for (IModule module : this.modules) {
            Collection<? extends TabContent> sections = module.getSections(this.entity);
            for (TabContent tabContent : sections) {
                this.container.addSection(tabContent);
            }
        }
        this.container.layout();
    }
}

