/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.specific;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.IColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;

public class GridCustomColumnDefinition<T>
implements IColumnDefinitionUI<T> {
    private GridCustomColumnInfo columnMetadata;

    public GridCustomColumnDefinition(GridCustomColumnInfo columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    @Override
    public int getWidth() {
        return 150;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        DataTypeCode dataType = this.columnMetadata.getDataType();
        return dataType == DataTypeCode.INTEGER || dataType == DataTypeCode.REAL;
    }

    @Override
    public boolean isVocabulary() {
        return this.columnMetadata.getDataType() == DataTypeCode.CONTROLLEDVOCABULARY;
    }

    @Override
    public Vocabulary tryGetVocabulary() {
        return null;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isDynamicProperty() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    @Override
    public DataTypeCode tryToGetDataType() {
        return null;
    }

    @Override
    public String tryGetLink(T entity) {
        return null;
    }

    @Override
    public Comparable<?> tryGetComparableValue(GridRowModel<T> rowModel) {
        return this.getPrimitiveValue(rowModel);
    }

    private PrimitiveValue getPrimitiveValue(GridRowModel<T> rowModel) {
        String columnId = this.columnMetadata.getCode();
        PrimitiveValue value = rowModel.findColumnValue(columnId);
        return value;
    }

    @Override
    public String getValue(GridRowModel<T> rowModel) {
        String value = this.getPrimitiveValue(rowModel).toString();
        return value != null ? value : "";
    }

    @Override
    public String getHeader() {
        return this.columnMetadata.getLabel();
    }

    @Override
    public String getIdentifier() {
        return this.columnMetadata.getCode();
    }

    @Override
    public String tryToGetProperty(String key) {
        return null;
    }

    private GridCustomColumnDefinition() {
    }

    @Override
    public boolean isCustom() {
        return true;
    }
}

