/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.ComputationData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetReportGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.IComputationAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.PerformComputationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.ProcessingDisplayCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import com.extjs.gxt.ui.client.widget.Window;

public class DataSetComputeUtils {
    public static IDelegatedAction createComputeAction(final IViewContext<ICommonClientServiceAsync> viewContext, final IDelegatedActionWithResult<AbstractExternalDataGrid.SelectedAndDisplayedItems> selectedDataSetsGetter, final DatastoreServiceDescription service, final ReportGeneratedCallback.IOnReportComponentGeneratedAction reportGeneratedAction) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems = (AbstractExternalDataGrid.SelectedAndDisplayedItems)selectedDataSetsGetter.execute();
                IComputationAction computationAction = DataSetComputeUtils.createComputationAction(viewContext, selectedAndDisplayedItems, reportGeneratedAction);
                ComputationData data = new ComputationData(service, computationAction, selectedAndDisplayedItems);
                this.createPerformComputationDialog(data).show();
            }

            private Window createPerformComputationDialog(ComputationData data) {
                String title = "Perform " + service.getLabel();
                return new PerformComputationDialog(viewContext, data, title);
            }
        };
    }

    private static IComputationAction createComputationAction(final IViewContext<ICommonClientServiceAsync> viewContext, final AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems, final ReportGeneratedCallback.IOnReportComponentGeneratedAction reportGeneratedAction) {
        return new IComputationAction(){

            @Override
            public void execute(DatastoreServiceDescription service, boolean computeOnSelected) {
                DisplayedOrSelectedDatasetCriteria criteria = selectedAndDisplayedItems.createCriteria(computeOnSelected);
                switch (service.getServiceKind()) {
                    case QUERIES: {
                        DataSetReportGenerator.generateAndInvoke(viewContext, service, criteria, reportGeneratedAction);
                        break;
                    }
                    case PROCESSING: {
                        ((ICommonClientServiceAsync)viewContext.getService()).processDatasets(service, criteria, AsyncCallbackWithProgressBar.decorate(new ProcessingDisplayCallback(viewContext), "Scheduling processing..."));
                    }
                }
            }
        };
    }
}

