/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.DeletionForceOptions;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedDatasetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;

public final class DataSetListDeletionConfirmationDialog
extends AbstractDataListDeletionConfirmationDialog<TableModelRowWithObject<AbstractExternalData>> {
    private final AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItemsOrNull;
    private final TableModelRowWithObject<AbstractExternalData> singleData;
    private DeletionForceOptions forceOptions;

    public DataSetListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, AsyncCallback<Void> callback, AbstractExternalDataGrid.SelectedAndDisplayedItems selectedAndDisplayedItems) {
        super(viewContext, selectedAndDisplayedItems.getSelectedItems(), callback);
        this.withRadio();
        this.singleData = null;
        this.selectedAndDisplayedItemsOrNull = selectedAndDisplayedItems;
    }

    public DataSetListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, AsyncCallback<Void> deletionCallback, TableModelRowWithObject<AbstractExternalData> data) {
        super(viewContext, Collections.singletonList(data), deletionCallback);
        this.singleData = data;
        this.selectedAndDisplayedItemsOrNull = null;
    }

    private IViewContext<ICommonClientServiceAsync> getViewContext() {
        return this.viewContext;
    }

    @Override
    protected void executeDeletion(AsyncCallback<Void> deletionCallback) {
        DeletionType deletionType = this.getDeletionType();
        if (this.selectedAndDisplayedItemsOrNull != null) {
            DisplayedOrSelectedDatasetCriteria uploadCriteria = this.selectedAndDisplayedItemsOrNull.createCriteria(this.isOnlySelected());
            this.getViewContext().getCommonService().deleteDataSets(uploadCriteria, (String)this.reason.getValue(), deletionType, this.getForceDisallowedTypesValue(), deletionCallback);
        } else {
            this.getViewContext().getCommonService().deleteDataSet(this.singleData.getObjectOrNull().getCode(), (String)this.reason.getValue(), deletionType, this.getForceDisallowedTypesValue(), deletionCallback);
        }
    }

    @Override
    protected String getEntityName() {
        return EntityKind.DATA_SET.getDescription();
    }

    @Override
    protected final RadioGroup createRadio() {
        IViewContext<ICommonClientServiceAsync> context = this.getViewContext();
        this.onlySelectedRadioOrNull = WidgetUtils.createRadio(context.getMessage("only_selected_radio", ((List)this.data).size()));
        return WidgetUtils.createAllOrSelectedRadioGroup(this.onlySelectedRadioOrNull, WidgetUtils.createRadio(context.getMessage("all_radio", this.selectedAndDisplayedItemsOrNull.getDisplayedItemsCount())), context.getMessage("data_sets_radio_group_label", new Object[0]), ((List)this.data).size());
    }

    @Override
    protected void extendForm() {
        super.extendForm();
        if (!this.isTrashEnabled()) {
            this.forceOptions = new DeletionForceOptions(this.viewContext);
            this.formPanel.add((Widget)this.forceOptions);
        }
    }

    private boolean getForceDisallowedTypesValue() {
        return this.forceOptions != null ? this.forceOptions.getForceDisallowedTypesValue() : false;
    }
}

