/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common.GridColumnChooserDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common.IExpressionHolder;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExpression;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractGridCustomExpressionEditOrRegisterDialog
extends AbstractRegistrationDialog {
    public static int FIELD_WIDTH = 400;
    public static int LABEL_WIDTH = 100;
    public static final String PUBLIC_FIELD = "public-field";
    public static final String EXPRESSION_FIELD = "expression-field";
    public static final String DESCRIPTION_FIELD = "description-field";
    public static final String NAME_FIELD = "name-field";
    public static final String INSERT_COLUMNS_LINK = "insert-columns-link";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final TextField<String> nameField;
    private final DescriptionField descriptionField;
    private final MultilineVarcharField expressionField;
    private final CheckBoxField publicField;
    private final LabelField insertColumnsLink;
    protected final String gridId;

    public AbstractGridCustomExpressionEditOrRegisterDialog(IViewContext<ICommonClientServiceAsync> viewContext, String title, IDelegatedAction postRegistrationCallback, String gridId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        super(viewContext, title, postRegistrationCallback);
        this.viewContext = viewContext;
        this.gridId = gridId;
        this.nameField = AbstractGridCustomExpressionEditOrRegisterDialog.createTextField(viewContext.getMessage("name", new Object[0]), true);
        this.addField((Widget)this.nameField);
        this.nameField.setId(AbstractGridCustomExpressionEditOrRegisterDialog.createId(gridId, NAME_FIELD));
        this.descriptionField = AbstractGridCustomExpressionEditOrRegisterDialog.createDescriptionField(viewContext, false);
        this.addField((Widget)this.descriptionField);
        this.descriptionField.setId(AbstractGridCustomExpressionEditOrRegisterDialog.createId(gridId, DESCRIPTION_FIELD));
        this.expressionField = this.createExpressionField();
        this.addField((Widget)this.expressionField);
        this.expressionField.setId(AbstractGridCustomExpressionEditOrRegisterDialog.createId(gridId, EXPRESSION_FIELD));
        this.insertColumnsLink = this.createInsertColumnsLink(viewContext.getMessage("insert_columns", new Object[0]), columnDataModelProvider);
        this.addField((Widget)this.insertColumnsLink);
        this.insertColumnsLink.setId(AbstractGridCustomExpressionEditOrRegisterDialog.createId(gridId, INSERT_COLUMNS_LINK));
        this.publicField = new CheckBoxField(viewContext.getMessage("is_public", new Object[0]), false);
        this.addField((Widget)this.publicField);
        this.publicField.setId(AbstractGridCustomExpressionEditOrRegisterDialog.createId(gridId, PUBLIC_FIELD));
        this.form.setLabelWidth(LABEL_WIDTH);
        this.form.setFieldWidth(FIELD_WIDTH);
        this.setWidth(this.form.getLabelWidth() + this.form.getFieldWidth() + 50);
        DialogWithOnlineHelpUtils.addHelpButton(viewContext, this, this.createHelpPageIdentifier());
    }

    protected abstract HelpPageIdentifier createHelpPageIdentifier();

    protected void initializeValues(AbstractExpression gridExpression) {
        FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, gridExpression.getDescription());
        FieldUtil.setValueWithUnescaping((Field<String>)this.expressionField, gridExpression.getExpression());
        FieldUtil.setValueWithUnescaping(this.nameField, gridExpression.getName());
        this.publicField.setValue(gridExpression.isPublic());
    }

    private LabelField createInsertColumnsLink(String label, final AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(label));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                GridColumnChooserDialog.show(AbstractGridCustomExpressionEditOrRegisterDialog.this.viewContext, columnDataModelProvider, AbstractGridCustomExpressionEditOrRegisterDialog.this.gridId, AbstractGridCustomExpressionEditOrRegisterDialog.asExpressionHolder(AbstractGridCustomExpressionEditOrRegisterDialog.this.expressionField));
            }
        });
        return result;
    }

    public static String createId(String gridId, String suffix) {
        String escapedGridId = gridId;
        escapedGridId = escapedGridId.replace("(", "_");
        escapedGridId = escapedGridId.replace(")", "_");
        return "openbis_grid-expression-edit-register-" + escapedGridId + suffix;
    }

    private MultilineVarcharField createExpressionField() {
        MultilineVarcharField field = new MultilineVarcharField(this.viewContext.getMessage("expression", new Object[0]), true, 10);
        return field;
    }

    protected NewColumnOrFilter getNewItemInfo() {
        NewColumnOrFilter newItem = new NewColumnOrFilter();
        newItem.setGridId(this.gridId);
        newItem.setDescription((String)this.descriptionField.getValue());
        newItem.setExpression((String)this.expressionField.getValue());
        newItem.setName((String)this.nameField.getValue());
        newItem.setPublic(this.publicField.getValue());
        return newItem;
    }

    protected void update(AbstractExpression gridExpression) {
        gridExpression.setDescription((String)this.descriptionField.getValue());
        gridExpression.setExpression((String)this.expressionField.getValue());
        gridExpression.setName((String)this.nameField.getValue());
        gridExpression.setPublic(this.publicField.getValue());
    }

    private static final IExpressionHolder asExpressionHolder(final MultilineVarcharField expressionField) {
        return new IExpressionHolder(){

            @Override
            public int getCursorPos() {
                return expressionField.getCursorPos();
            }

            @Override
            public String getValue() {
                return (String)expressionField.getValue();
            }

            @Override
            public void setCursorPos(int position) {
                expressionField.setCursorPos(position);
            }

            @Override
            public void setValue(String value) {
                expressionField.setValue(value);
            }
        };
    }
}

