/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common.GridColumnChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common.IExpressionHolder;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

class GridColumnChooserDialog
extends Dialog {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public static void show(IViewContext<ICommonClientServiceAsync> viewContext, AbstractColumnSettingsDataModelProvider columnDataModelProvider, String gridId, IExpressionHolder expressionField) {
        new GridColumnChooserDialog(viewContext, gridId).show(columnDataModelProvider, expressionField);
    }

    private GridColumnChooserDialog(IViewContext<ICommonClientServiceAsync> viewContext, String gridId) {
        this.viewContext = viewContext;
        this.setHeight(450);
        this.setWidth(700);
        this.setLayout((Layout)new FitLayout());
        this.setHeading(String.valueOf(viewContext.getMessage("columns", new Object[0])) + " [" + gridId + "]");
        this.setModal(true);
    }

    private void show(AbstractColumnSettingsDataModelProvider columnDataModelProvider, final IExpressionHolder expressionField) {
        assert (columnDataModelProvider != null) : "columnModels not specified";
        this.removeAll();
        final GridColumnChooser columnChooser = new GridColumnChooser(columnDataModelProvider, this.viewContext);
        Component columnChooserComponent = columnChooser.getComponent();
        this.add(columnChooserComponent);
        columnChooserComponent.sinkEvents(2);
        columnChooserComponent.addListener(Events.OnDoubleClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                GridColumnChooserDialog.this.insertColumnsIntoExpression(expressionField, columnChooser);
            }
        });
        super.show();
        this.getButtonById("ok").addListener(Events.Select, (Listener)new SelectionListener<ComponentEvent>(){

            public void componentSelected(ComponentEvent ce) {
                GridColumnChooserDialog.this.insertColumnsIntoExpression(expressionField, columnChooser);
            }
        });
    }

    private void insertColumnsIntoExpression(IExpressionHolder expressionField, GridColumnChooser columnChooser) {
        String expression = expressionField.getValue() != null ? expressionField.getValue() : "";
        int cursor = expressionField.getCursorPos();
        for (String column : columnChooser.getSelectedItems()) {
            String addressWithSeparator = String.valueOf(column) + " ";
            expression = String.valueOf(expression.substring(0, cursor)) + addressWithSeparator + expression.substring(cursor);
            cursor += addressWithSeparator.length();
        }
        expressionField.setValue(expression);
        expressionField.setCursorPos(cursor);
        this.hide();
    }
}

