/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.MaterialTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMaterialDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import java.util.Set;

public class MaterialBrowserToolbar
extends ToolBar
implements IDisposableComponent,
ICriteriaProvider<ListMaterialDisplayCriteria> {
    public static final String ID = "material-browser-toolbar";
    private final MaterialTypeSelectionWidget selectMaterialTypeCombo;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public MaterialBrowserToolbar(IViewContext<ICommonClientServiceAsync> viewContext, String initialMaterialTypeOrNull, String displayTypeIdOrNull) {
        this.viewContext = viewContext;
        this.selectMaterialTypeCombo = MaterialTypeSelectionWidget.create(viewContext, displayTypeIdOrNull, initialMaterialTypeOrNull, ID);
        this.display();
    }

    public void setCriteriaChangedListeners(final IDelegatedAction action) {
        this.selectMaterialTypeCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<MaterialTypeModel>(){

            public void selectionChanged(SelectionChangedEvent<MaterialTypeModel> se) {
                action.execute();
            }
        });
    }

    private void display() {
        this.setBorders(true);
        this.add((Component)new LabelToolItem(String.valueOf(this.viewContext.getMessage("material_type", new Object[0])) + ":"));
        this.add((Component)this.selectMaterialTypeCombo);
    }

    @Override
    public final ListMaterialDisplayCriteria tryGetCriteria() {
        MaterialType selectedType = this.selectMaterialTypeCombo.tryGetSelectedMaterialType();
        if (selectedType == null) {
            return null;
        }
        return ListMaterialDisplayCriteria.createForMaterialType(selectedType);
    }

    protected final void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.MATERIAL_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback entityTypeRefreshCallback) {
        if (observedModifications.contains(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.MATERIAL_TYPE)) || observedModifications.contains(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)) || observedModifications.contains(DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT))) {
            this.selectMaterialTypeCombo.refreshStore(entityTypeRefreshCallback);
        } else {
            entityTypeRefreshCallback.postRefresh(true);
        }
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        if (this.selectMaterialTypeCombo != null) {
            this.selectMaterialTypeCombo.dispose();
        }
    }
}

