/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMetaprojectsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class MetaprojectGrid
extends TypedTableGrid<Metaproject> {
    private IChosenEntitiesProvider<String> chosenProvider;
    public static final String METAPROJECT_CHOOSER_GRID_ID = "openbis_metaproject-chooser-grid";

    public static DisposableEntityChooser<TableModelRowWithObject<Metaproject>> createChooser(IViewContext<?> viewContext, IChosenEntitiesProvider<String> chosenProvider) {
        MetaprojectGrid grid = new MetaprojectGrid(viewContext, METAPROJECT_CHOOSER_GRID_ID, DisplayTypeIDGenerator.METAPROJECT_CHOOSER_GRID, chosenProvider);
        grid.allowMultipleSelection();
        return grid.asDisposableWithoutToolbar();
    }

    private MetaprojectGrid(IViewContext<?> viewContext, String gridId, DisplayTypeIDGenerator gridDisplayTypeId, IChosenEntitiesProvider<String> chosenProvider) {
        super(viewContext.getCommonViewContext(), gridId, true, gridDisplayTypeId);
        this.chosenProvider = chosenProvider;
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Metaproject>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Metaproject>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Metaproject>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Metaproject>> callback) {
        ListMetaprojectsCriteria listCriteria = new ListMetaprojectsCriteria();
        List<String> chosenMetaprojects = this.chosenProvider.getEntities();
        if (chosenMetaprojects != null && this.chosenProvider.isBlackList()) {
            listCriteria.setBlacklist(new HashSet<String>(chosenMetaprojects));
        } else if (chosenMetaprojects != null && !this.chosenProvider.isBlackList()) {
            listCriteria.setWhitelist(new HashSet<String>(chosenMetaprojects));
        }
        listCriteria.copyPagingConfig(resultSetConfig);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listMetaprojects(listCriteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Metaproject>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportMetaprojects(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("NAME");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }
}

