/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PropertyValueRenderers;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.DatePropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.IPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.ObjectArrayPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.ObjectPropertyValueRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GenericEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermEntityProperty;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class PropertyGrid
extends Grid {
    private final IPropertyValueRenderer<Object> defaultPropertyValueRenderer;
    private final Map<Class<?>, IPropertyValueRenderer<?>> propertyValueRenderers = new HashMap();
    private Map<String, Object> properties;
    private final IViewContext<?> viewContext;
    private final IMessageProvider messageProvider;

    public PropertyGrid(IViewContext<?> viewContext, int rows) {
        this(viewContext, rows, "30%");
    }

    public PropertyGrid(IViewContext<?> viewContext, int rows, String widthOfFirstColumn) {
        super(rows, 2);
        this.messageProvider = viewContext;
        this.viewContext = viewContext;
        this.setStyleName("property-grid");
        this.getColumnFormatter().addStyleName(0, "header");
        this.getColumnFormatter().setWidth(0, widthOfFirstColumn);
        this.defaultPropertyValueRenderer = new ObjectPropertyValueRenderer(this.messageProvider);
        this.registerDefaultPropertyValueRenderers();
    }

    private final void registerDefaultPropertyValueRenderers() {
        this.registerPropertyValueRenderer(Date.class, new DatePropertyValueRenderer(this.messageProvider, "yyyy-MM-dd HH:mm:ss"));
        this.registerPropertyValueRenderer(Person.class, PropertyValueRenderers.createPersonPropertyValueRenderer(this.messageProvider));
        this.registerPropertyValueRenderer(Deletion.class, PropertyValueRenderers.createDeletionPropertyValueRenderer(this.messageProvider));
        this.registerPropertyValueRenderer(ContainerDataSet.class, PropertyValueRenderers.createExternalDataPropertyValueRenderer(this.viewContext));
        this.registerPropertyValueRenderer(PhysicalDataSet.class, PropertyValueRenderers.createExternalDataPropertyValueRenderer(this.viewContext));
        this.registerPropertyValueRenderer(Experiment.class, PropertyValueRenderers.createExperimentPropertyValueRenderer(this.viewContext));
        this.registerPropertyValueRenderer(Sample.class, PropertyValueRenderers.createSamplePropertyValueRenderer(this.viewContext, true));
        this.registerPropertyValueRenderer(Project.class, PropertyValueRenderers.createProjectPropertyValueRenderer(this.viewContext));
        IPropertyValueRenderer<IEntityProperty> propertyValueRenderer = PropertyValueRenderers.createEntityPropertyPropertyValueRenderer(this.viewContext);
        this.registerPropertyValueRenderer(EntityProperty.class, propertyValueRenderer);
        this.registerPropertyValueRenderer(GenericEntityProperty.class, propertyValueRenderer);
        this.registerPropertyValueRenderer(ManagedEntityProperty.class, propertyValueRenderer);
        this.registerPropertyValueRenderer(MaterialEntityProperty.class, propertyValueRenderer);
        this.registerPropertyValueRenderer(VocabularyTermEntityProperty.class, propertyValueRenderer);
    }

    private final <T> IPropertyValueRenderer<? super T> getPropertyValueRenderer(T value) {
        if (value == null) {
            return this.defaultPropertyValueRenderer;
        }
        Class<?> clazz = value.getClass();
        IPropertyValueRenderer<?> renderer = this.propertyValueRenderers.get(clazz);
        if (renderer == null) {
            if (clazz.isArray()) {
                Object[] array = (Object[])value;
                if (array.length > 0) {
                    return new ObjectArrayPropertyValueRenderer<Object>(this.messageProvider, this.getPropertyValueRenderer(array[0]));
                }
                return new ObjectArrayPropertyValueRenderer<Object>(this.messageProvider, this.defaultPropertyValueRenderer);
            }
            return this.defaultPropertyValueRenderer;
        }
        return renderer;
    }

    public final <V, T extends V> void registerPropertyValueRenderer(Class<T> clazz, IPropertyValueRenderer<V> propertyValueRenderer) {
        this.propertyValueRenderers.put(clazz, propertyValueRenderer);
    }

    public final <T> void unregisterPropertyValueRenderer(Class<T> clazz) {
        this.propertyValueRenderers.remove(clazz);
    }

    public final void setProperties(Map<String, Object> properties) {
        this.properties = properties;
        assert (properties != null) : "Unspecified properties.";
        this.resizeRows(properties.size());
        this.addPropertiesToTable(properties, 0);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private final <T> Widget getAsWidget(T value) {
        IPropertyValueRenderer<T> propertyValueRenderer = this.getPropertyValueRenderer(value);
        return propertyValueRenderer.getAsWidget(value);
    }

    public void addAdditionalProperties(String title, Map<String, Object> props) {
        int row = this.getRowCount();
        this.resizeRows(row + 1 + props.size());
        this.setHTML(row, 0, title);
        Element element = this.getCellFormatter().getElement(row, 0);
        element.setAttribute("colspan", "2");
        element.setAttribute("class", "properties-sub-section");
        this.getCellFormatter().getElement(row, 1).setAttribute("style", "display: none");
        this.addPropertiesToTable(props, row + 1);
    }

    private void addPropertiesToTable(Map<String, Object> props, int initRow) {
        int row = initRow;
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Widget widget = this.getAsWidget(value);
            this.setHTML(row, 0, key);
            this.setWidget(row++, 1, widget);
        }
    }
}

