/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PropertyTypeRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import java.util.ArrayList;
import java.util.List;

public final class EntityTypePropertyTypeSelectionWidget
extends DropDownList<EntityTypePropertyTypeComboModel, EntityTypePropertyType<?>> {
    public static final String TOP_ITEM_CODE = "(top)";
    private static final String EMPTY_RESULT_SUFFIX = "assigned property types";
    private static final String CHOOSE_SUFFIX = "assigned property type";
    private static final String SUFFIX = "entity-type-property-type";

    public EntityTypePropertyTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix, List<EntityTypePropertyType<?>> etpts, String initialValueOrNull) {
        super(viewContext, SUFFIX + idSuffix, "position_after", "code_with_label", CHOOSE_SUFFIX, EMPTY_RESULT_SUFFIX);
        this.setETPTs(etpts);
        this.selectInitialValue(initialValueOrNull);
        this.setTemplate(GWTUtils.getTooltipTemplate("code_with_label", "tooltip"));
    }

    private void setETPTs(List<EntityTypePropertyType<?>> etpts) {
        ArrayList<EntityTypePropertyTypeComboModel> models = new ArrayList<EntityTypePropertyTypeComboModel>();
        models.addAll(this.convertItems(etpts));
        this.updateStore(models);
        this.getPropertyEditor().setList(this.store.getModels());
    }

    private void selectInitialValue(String initialValueOrNull) {
        if (initialValueOrNull != null) {
            this.trySelectByCode(initialValueOrNull);
            this.updateOriginalValue();
        }
    }

    public void trySelectByCode(String termCode) {
        GWTUtils.setSelectedItem(this, "code", termCode);
    }

    public final Long getSelectedEntityTypePropertyTypeOrdinal() {
        EntityTypePropertyTypeComboModel selectedItem = (EntityTypePropertyTypeComboModel)((Object)this.getValue());
        assert (selectedItem != null);
        return selectedItem.getOrdinal();
    }

    @Override
    protected List<EntityTypePropertyTypeComboModel> convertItems(List<EntityTypePropertyType<?>> etpts) {
        ArrayList<EntityTypePropertyTypeComboModel> result = new ArrayList<EntityTypePropertyTypeComboModel>();
        for (EntityTypePropertyType<?> etpt : etpts) {
            result.add(new EntityTypePropertyTypeComboModel(etpt));
        }
        return result;
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<EntityTypePropertyType<?>>> callback) {
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE);
    }

    static class EntityTypePropertyTypeComboModel
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;
        private static final String ORDINAL = "ordinal";

        public EntityTypePropertyTypeComboModel(EntityTypePropertyType<?> entity) {
            this.set("code", entity == null ? EntityTypePropertyTypeSelectionWidget.TOP_ITEM_CODE : entity.getPropertyType().getCode());
            this.set("code_with_label", entity == null ? EntityTypePropertyTypeSelectionWidget.TOP_ITEM_CODE : this.getDisplayName(entity));
            this.set(ORDINAL, entity == null ? 0L : entity.getOrdinal());
            this.set("tooltip", entity == null ? null : this.getTooltip(entity));
            this.set("object", entity);
        }

        private Object getTooltip(EntityTypePropertyType<?> entity) {
            return PropertyTypeRenderer.renderAsTooltip(entity.getPropertyType(), entity.getSection());
        }

        private String getDisplayName(EntityTypePropertyType<?> entity) {
            return String.valueOf(entity.getSection() != null ? String.valueOf(entity.getSection()) + ": " : "") + entity.getPropertyType().getLabel();
        }

        public Long getOrdinal() {
            return (Long)this.get(ORDINAL);
        }
    }
}

