/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractServlet
extends AbstractController {
    protected final String getSessionToken(HttpServletRequest request) {
        String sessionToken = request.getParameter("sessionID");
        if (sessionToken != null) {
            return sessionToken;
        }
        return this.getParameter(request, "openbis-session-token");
    }

    private String getParameter(HttpServletRequest request, String parameterName) {
        HttpSession session = request.getSession(false);
        assert (session != null) : "Session must be specified.";
        return (String)session.getAttribute(parameterName);
    }

    protected final void writeResponse(HttpServletResponse response, String value) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write(value);
        writer.flush();
        writer.close();
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.respondToRequest(request, response);
        }
        catch (UserFailureException ex) {
            this.writeResponse(response, ex.getMessage());
        }
        return null;
    }

    protected abstract void respondToRequest(HttpServletRequest var1, HttpServletResponse var2) throws Exception, IOException;
}

