/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class RoleAssignmentProvider
extends AbstractCommonTableModelProvider<RoleAssignment> {
    public RoleAssignmentProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<RoleAssignment> createTableModel() {
        List<RoleAssignment> roles = this.commonServer.listRoleAssignments(this.sessionToken);
        TypedTableModelBuilder<RoleAssignment> builder = new TypedTableModelBuilder<RoleAssignment>();
        builder.addColumn("PERSON");
        builder.addColumn("AUTHORIZATION_GROUP");
        builder.addColumn("SPACE");
        builder.addColumn("ROLE");
        builder.addColumn("DATABASE_INSTANCE");
        for (RoleAssignment roleAssignment : roles) {
            builder.addRow(roleAssignment);
            Person person = roleAssignment.getPerson();
            AuthorizationGroup group = roleAssignment.getAuthorizationGroup();
            Space space = roleAssignment.getSpace();
            DatabaseInstance databaseInstance = roleAssignment.getInstance();
            if (databaseInstance == null) {
                databaseInstance = space.getInstance();
            }
            builder.column("PERSON").addString(person == null ? "" : person.getUserId());
            builder.column("AUTHORIZATION_GROUP").addString(group == null ? "" : group.getCode());
            builder.column("SPACE").addString(space == null ? "" : space.getCode());
            builder.column("ROLE").addString(roleAssignment.getCode());
            builder.column("DATABASE_INSTANCE").addString(databaseInstance.getCode());
        }
        return builder.getModel();
    }
}

