/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.reflection.IClassFilter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IIndexedEntityFinder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.search.annotations.Indexed;

public final class PackageBasedIndexedEntityFinder
implements IIndexedEntityFinder {
    private Set<Class<?>> indexedEntities;

    public PackageBasedIndexedEntityFinder(String packageName) {
        assert (packageName != null) : "Unspecified package name.";
        this.indexedEntities = this.createIndexedEntities(packageName);
    }

    private HashSet<Class<?>> createIndexedEntities(String packageName) {
        List<Class<?>> classes = ClassUtils.listClasses(packageName, new IClassFilter(){

            @Override
            public boolean accept(String fullyQualifiedClassName) {
                return !fullyQualifiedClassName.endsWith("Test");
            }

            @Override
            public final boolean accept(Class<?> clazz) {
                if (clazz.isAnnotationPresent(Indexed.class)) {
                    return clazz.getSuperclass() == null || !this.accept(clazz.getSuperclass());
                }
                return false;
            }
        });
        return new HashSet(classes);
    }

    @Override
    public final Set<Class<?>> getIndexedEntities() {
        return this.indexedEntities;
    }
}

