/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="data_stores")
@Friend(toClasses={DataStoreServicePE.class})
public final class DataStorePE
extends AbstractIdAndCodeHolder<DataStorePE> {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private String code;
    private Date registrationDate;
    private String downloadUrl;
    private String remoteUrl;
    private String sessionToken;
    private DatabaseInstancePE databaseInstance;
    private Date modificationDate;
    private boolean archiverConfigured;
    private Set<DataStoreServicePE> services = new HashSet<DataStoreServicePE>();
    private String serializedDataSourceDefinitions;

    public final void setId(Long id) {
        this.id = id;
    }

    public final void setCode(String code) {
        this.code = code;
    }

    @Column(name="download_url", updatable=true)
    @NotNull(message="Download URL can not be null.")
    public final String getDownloadUrl() {
        return this.downloadUrl;
    }

    public final void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Column(name="remote_url", updatable=true)
    @NotNull(message="Remote URL can not be null.")
    public final String getRemoteUrl() {
        return this.remoteUrl;
    }

    public final void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    @Column(name="session_token", updatable=true)
    @NotNull(message="Session token can not be null.")
    public final String getSessionToken() {
        return this.sessionToken;
    }

    public final void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public final Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public final void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @NotNull
    @Column(name="is_archiver_configured", updatable=true)
    public boolean isArchiverConfigured() {
        return this.archiverConfigured;
    }

    public void setArchiverConfigured(boolean archiverConfigured) {
        this.archiverConfigured = archiverConfigured;
    }

    @Column(name="data_source_definitions", updatable=true)
    public String getSerializedDataSourceDefinitions() {
        return this.serializedDataSourceDefinitions;
    }

    public void setSerializedDataSourceDefinitions(String serializedDataSourceDefinitions) {
        this.serializedDataSourceDefinitions = serializedDataSourceDefinitions;
    }

    @Override
    @Column(name="code")
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public final String getCode() {
        return this.code;
    }

    @Override
    @Id
    @SequenceGenerator(name="DATA_STORE_ID_SEQ", sequenceName="DATA_STORE_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATA_STORE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="dataStoreInternal", orphanRemoval=true)
    @NotNull(message="Data store services can not be null.")
    private Set<DataStoreServicePE> getServicesInternal() {
        return this.services;
    }

    private void setServicesInternal(Set<DataStoreServicePE> services) {
        this.services = services;
    }

    public void setServices(Set<DataStoreServicePE> services) {
        this.getServicesInternal().clear();
        for (DataStoreServicePE service : services) {
            this.addService(service);
        }
    }

    @Private
    void addService(DataStoreServicePE service) {
        DataStorePE dataStore = service.getDataStore();
        if (dataStore != null) {
            dataStore.getServicesInternal().remove(service);
        }
        service.setDataStoreInternal(this);
        this.getServicesInternal().add(service);
    }

    @Transient
    public Set<DataStoreServicePE> getServices() {
        return this.getServicesInternal();
    }
}

