/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.demo.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DummyComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.ClientPluginAdapter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.demo.client.web.client.IDemoClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.demo.client.web.client.application.DemoSampleViewer;
import ch.systemsx.cisd.openbis.plugin.demo.client.web.client.application.DemoViewContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.GenericViewContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample.GenericSampleRegistrationForm;
import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClientPluginFactory
extends AbstractClientPluginFactory<DemoViewContext> {
    public ClientPluginFactory(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        super(originalViewContext);
    }

    @Override
    protected final DemoViewContext createViewContext(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        return new DemoViewContext(originalViewContext);
    }

    @Override
    public final Set<String> getEntityTypeCodes(EntityKind entityKind) {
        if (entityKind == EntityKind.SAMPLE) {
            return Collections.singleton("DEMO_PLUGIN");
        }
        return Collections.emptySet();
    }

    @Override
    public <T extends BasicEntityType, I extends IIdAndCodeHolder> IClientPlugin<T, I> createClientPlugin(EntityKind entityKind) {
        if (EntityKind.EXPERIMENT.equals(entityKind)) {
            return new ExperimentClientPlugin();
        }
        if (EntityKind.SAMPLE.equals(entityKind)) {
            return new SampleClientPlugin();
        }
        throw new UnsupportedOperationException("IClientPlugin for entity kind '" + entityKind + "' not implemented yet.");
    }

    private static ITabItem createDummyTab(String identifier, IViewContext<?> viewContext) {
        DummyComponent component = new DummyComponent();
        return DefaultTabItem.createUnaware(identifier, (Component)component, false, viewContext);
    }

    @Override
    public IModule maybeCreateModule() {
        return null;
    }

    private final class ExperimentClientPlugin
    extends ClientPluginAdapter<ExperimentType, IIdAndCodeHolder> {
        private ExperimentClientPlugin() {
        }

        @Override
        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    return ClientPluginFactory.createDummyTab(this.getTabTitle(), ClientPluginFactory.this.getViewContext());
                }

                @Override
                public String getId() {
                    return "openbis_dummy-component";
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return entity.getCode();
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }
    }

    private final class SampleClientPlugin
    implements IClientPlugin<SampleType, IIdAndCodeHolder> {
        private SampleClientPlugin() {
        }

        @Override
        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            final TechId sampleId = TechId.create(entity);
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DemoSampleViewer sampleViewer = new DemoSampleViewer((IViewContext<IDemoClientServiceAsync>)ClientPluginFactory.this.getViewContext(), sampleId);
                    return DefaultTabItem.createUnaware(this.getTabTitle(), (Component)sampleViewer, false, ClientPluginFactory.this.getViewContext());
                }

                @Override
                public String getId() {
                    return DemoSampleViewer.createId(sampleId);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return entity.getCode();
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }

        @Override
        public final DatabaseModificationAwareWidget createRegistrationForEntityType(SampleType sampleType, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext context) {
            GenericSampleRegistrationForm form = new GenericSampleRegistrationForm((IViewContext<IGenericClientServiceAsync>)new GenericViewContext(((DemoViewContext)ClientPluginFactory.this.getViewContext()).getCommonViewContext()), inputWidgetDescriptions, sampleType, context);
            return new DatabaseModificationAwareWidget((Widget)form, (IDatabaseModificationObserver)form);
        }

        @Override
        public final Widget createBatchRegistrationForEntityType(SampleType sampleType) {
            return new DummyComponent();
        }

        @Override
        public final Widget createBatchUpdateForEntityType(SampleType sampleType) {
            return new DummyComponent();
        }

        @Override
        public AbstractTabItemFactory createEntityEditor(final IIdAndCodeHolder identifiable) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    return ClientPluginFactory.createDummyTab(this.getTabTitle(), ClientPluginFactory.this.getViewContext());
                }

                @Override
                public String getId() {
                    return "openbis_dummy-component";
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE, HelpPageIdentifier.HelpPageAction.EDIT);
                }

                @Override
                public String getTabTitle() {
                    return identifiable.getCode();
                }

                @Override
                public String tryGetLink() {
                    return null;
                }
            };
        }
    }
}

