/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.FormPanelListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.UrlParamsHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file.BasicFileFieldManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchRegistrationResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FormEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public abstract class AbstractExperimentBatchRegistrationForm
extends AbstractRegistrationForm {
    private static final String FIELD_LABEL_TEMPLATE = "File";
    private static final int DEFAULT_NUMBER_OF_FILES = 1;
    private final BasicFileFieldManager fileFieldsManager;
    private final String sessionKey;
    protected final IViewContext<IGenericClientServiceAsync> viewContext;
    protected final ExperimentType type;
    private final BatchOperationKind batchOperationKind;

    public AbstractExperimentBatchRegistrationForm(IViewContext<IGenericClientServiceAsync> viewContext, ExperimentType type, BatchOperationKind batchOperationKind, String sessionKey) {
        super(viewContext.getCommonViewContext(), AbstractExperimentBatchRegistrationForm.createId(sessionKey));
        this.viewContext = viewContext;
        this.type = type;
        this.batchOperationKind = batchOperationKind;
        this.sessionKey = sessionKey;
        this.fileFieldsManager = new BasicFileFieldManager(sessionKey, 1, FIELD_LABEL_TEMPLATE);
        this.fileFieldsManager.setMandatory();
        this.setScrollMode(Style.Scroll.AUTO);
        this.addUploadFeatures(sessionKey);
    }

    protected abstract void save();

    protected String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    protected final void submitValidForm() {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.addFormFields();
    }

    @Override
    protected void resetFieldsAfterSave() {
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            attachmentField.reset();
        }
        this.updateDirtyCheckAfterSave();
    }

    private static String createId(String sessionKey) {
        return "openbis_" + sessionKey;
    }

    private LabelField createTemplateField() {
        LabelField result = new LabelField(LinkRenderer.renderAsLink(this.viewContext.getMessage("file_template_label", new Object[0])));
        result.sinkEvents(1);
        result.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                WindowUtils.openWindow(UrlParamsHelper.createTemplateURL(EntityKind.EXPERIMENT, AbstractExperimentBatchRegistrationForm.this.type, false, false, AbstractExperimentBatchRegistrationForm.this.batchOperationKind));
            }
        });
        return result;
    }

    private final void addFormFields() {
        this.formPanel.add((Widget)this.createTemplateField());
        for (FileUploadField attachmentField : this.fileFieldsManager.getFields()) {
            this.formPanel.add((Widget)DatabaseModificationAwareField.wrapUnaware(attachmentField).get());
        }
        this.formPanel.addListener(Events.BeforeSubmit, (Listener)new Listener<FormEvent>(){

            public void handleEvent(FormEvent be) {
                AbstractExperimentBatchRegistrationForm.this.infoBox.displayProgress(AbstractExperimentBatchRegistrationForm.this.messageProvider.getMessage("progress_uploading", new Object[0]));
            }
        });
        this.formPanel.addListener(Events.Submit, new FormPanelListener(this.infoBox){

            @Override
            protected void onSuccessfullUpload() {
                AbstractExperimentBatchRegistrationForm.this.infoBox.displayProgress(AbstractExperimentBatchRegistrationForm.this.messageProvider.getMessage("progress_processing", new Object[0]));
                AbstractExperimentBatchRegistrationForm.this.save();
            }

            @Override
            protected void setUploadEnabled() {
                AbstractExperimentBatchRegistrationForm.this.setUploadEnabled(true);
            }
        });
        this.redefineSaveListeners();
    }

    private void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractExperimentBatchRegistrationForm.this.formPanel.isValid()) {
                    if (AbstractExperimentBatchRegistrationForm.this.fileFieldsManager.filesDefined() > 0) {
                        AbstractExperimentBatchRegistrationForm.this.setUploadEnabled(false);
                        AbstractExperimentBatchRegistrationForm.this.formPanel.submit();
                    } else {
                        AbstractExperimentBatchRegistrationForm.this.save();
                    }
                }
            }
        });
    }

    @Override
    protected void setUploadEnabled(boolean enabled) {
        super.setUploadEnabled(enabled);
        this.infoBoxResetListener.setEnabled(enabled);
    }

    final class RegisterExperimentsCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<List<BatchRegistrationResult>> {
        RegisterExperimentsCallback(IViewContext<IGenericClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected String createSuccessfullRegistrationInfo(List<BatchRegistrationResult> result) {
            StringBuilder builder = new StringBuilder();
            for (BatchRegistrationResult batchRegistrationResult : result) {
                builder.append("<b>" + batchRegistrationResult.getFileName() + "</b>: ");
                builder.append(batchRegistrationResult.getMessage());
                builder.append("<br />");
            }
            return builder.toString();
        }
    }
}

