/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDirectlyConnectedController;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;

class SampleDataSetBrowser
extends AbstractExternalDataGrid {
    private static final String PREFIX = "sample-data-section_";
    public static final String ID_PREFIX = "openbis_sample-data-section_";
    private final IDirectlyConnectedController connectionTypeProvider;
    private final TechId sampleId;

    public static IDisposableComponent create(IViewContext<?> viewContext, TechId sampleId, final BasicEntityType sampleType, IDirectlyConnectedController connectionTypeProvider) {
        IViewContext<ICommonClientServiceAsync> commonViewContext = viewContext.getCommonViewContext();
        SampleDataSetBrowser browser = new SampleDataSetBrowser(commonViewContext, sampleId, connectionTypeProvider){

            @Override
            public String getGridDisplayTypeID() {
                return String.valueOf(super.getGridDisplayTypeID()) + "-" + sampleType.getCode();
            }
        };
        return browser.asDisposableWithoutToolbar();
    }

    private SampleDataSetBrowser(IViewContext<ICommonClientServiceAsync> viewContext, TechId sampleId, IDirectlyConnectedController connectionTypeProvider) {
        super(viewContext, SampleDataSetBrowser.createBrowserId(sampleId), SampleDataSetBrowser.createGridId(sampleId), DisplayTypeIDGenerator.SAMPLE_DETAILS_GRID);
        this.sampleId = sampleId;
        this.connectionTypeProvider = connectionTypeProvider;
        connectionTypeProvider.setOnChangeAction(new IDelegatedAction(){

            @Override
            public void execute() {
                SampleDataSetBrowser.this.refresh();
            }
        });
    }

    public static final String createGridId(TechId sampleId) {
        return String.valueOf(SampleDataSetBrowser.createBrowserId(sampleId)) + "-grid";
    }

    public static final String createBrowserId(TechId sampleId) {
        return ID_PREFIX + sampleId;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> callback) {
        boolean onlyDirectlyConnected = this.connectionTypeProvider.isOnlyDirectlyConnected();
        ((ICommonClientServiceAsync)this.viewContext.getService()).listSampleDataSets(this.sampleId, resultSetConfig, onlyDirectlyConnected, callback);
    }

    /* synthetic */ SampleDataSetBrowser(IViewContext iViewContext, TechId techId, IDirectlyConnectedController iDirectlyConnectedController, SampleDataSetBrowser sampleDataSetBrowser) {
        this((IViewContext<ICommonClientServiceAsync>)iViewContext, techId, iDirectlyConnectedController);
    }
}

