/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import java.util.HashMap;
import java.util.Map;

class AccessionNumberURLCreator {
    private static final String UNIPROT_URL_TEMPLATE = "http://www.uniprot.org/uniprot/$id";
    private static final String UNIPROT_QUERY_URL_TEMPLATE = "http://www.uniprot.org/uniprot/?query=$id";
    private static final Map<String, String> URL_TEMPLATES = AccessionNumberURLCreator.createURLTemplates();

    AccessionNumberURLCreator() {
    }

    private static final Map<String, String> createURLTemplates() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sp", UNIPROT_URL_TEMPLATE);
        map.put("tr", UNIPROT_URL_TEMPLATE);
        map.put("ipi", UNIPROT_QUERY_URL_TEMPLATE);
        map.put("ens", UNIPROT_QUERY_URL_TEMPLATE);
        map.put("rs", UNIPROT_QUERY_URL_TEMPLATE);
        map.put("ll", UNIPROT_QUERY_URL_TEMPLATE);
        map.put("fb", UNIPROT_QUERY_URL_TEMPLATE);
        map.put("gi", "http://www.ncbi.nlm.nih.gov/protein/$id");
        map.put("isb", "http://www.ebi.ac.uk/ebisearch/search.ebi?db=proteinSequences&t=$id");
        return map;
    }

    static String tryToCreateURL(String typeOrNull, String accessionNumber) {
        if (typeOrNull == null) {
            return AccessionNumberURLCreator.eval(UNIPROT_URL_TEMPLATE, accessionNumber);
        }
        String template = URL_TEMPLATES.get(typeOrNull);
        return template == null ? null : AccessionNumberURLCreator.eval(template, accessionNumber);
    }

    private static String eval(String template, String value) {
        return template.replaceAll("\\$id", value);
    }
}

