/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.IGenericClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.AbstractGenericEntityRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.DelegatedClientPlugin;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.GenericViewContext;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentEditForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentRegistrationForm;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.experiment.GenericExperimentViewer;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ExperimentViewer;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.PhosphoNetXModule;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ViewContext;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientPluginFactory
extends AbstractClientPluginFactory<ViewContext> {
    public ClientPluginFactory(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        super(originalViewContext);
    }

    @Override
    protected ViewContext createViewContext(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        return new ViewContext(originalViewContext);
    }

    @Override
    public boolean isEnabled() {
        return this.checkEnabledProperty("proteomics");
    }

    @Override
    public IModule maybeCreateModule() {
        return new PhosphoNetXModule((IViewContext<IPhosphoNetXClientServiceAsync>)this.getViewContext());
    }

    @Override
    public Set<String> getEntityTypeCodes(EntityKind entityKind) {
        if (entityKind == EntityKind.EXPERIMENT) {
            return new HashSet<String>(Arrays.asList("MS_SEARCH", "MS_QUANTIFICATION"));
        }
        return Collections.emptySet();
    }

    @Override
    public <T extends BasicEntityType, I extends IIdAndCodeHolder> IClientPlugin<T, I> createClientPlugin(EntityKind entityKind) {
        if (EntityKind.EXPERIMENT.equals(entityKind)) {
            return new ExperimentClientPlugin((IViewContext)this.getViewContext());
        }
        throw new UnsupportedOperationException("IClientPlugin for entity kind '" + entityKind + "' not implemented yet.");
    }

    private final class ExperimentClientPlugin
    extends DelegatedClientPlugin<ExperimentType> {
        private ExperimentClientPlugin(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
            super(viewContext, EntityKind.EXPERIMENT);
        }

        @Override
        public final AbstractTabItemFactory createEntityViewer(final IEntityInformationHolderWithPermId entity) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent experimentViewer = ExperimentViewer.create(ClientPluginFactory.this.getViewContext(), entity.getEntityType(), (IIdAndCodeHolder)entity);
                    return DefaultTabItem.create(this.getTabTitle(), experimentViewer, ClientPluginFactory.this.getViewContext(), false);
                }

                @Override
                public String getId() {
                    return GenericExperimentViewer.createId(entity);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.VIEW);
                }

                @Override
                public String getTabTitle() {
                    return ExperimentClientPlugin.this.getViewerTitle("experiment", entity);
                }

                @Override
                public String tryGetLink() {
                    return LinkExtractor.tryExtract(entity);
                }
            };
        }

        @Override
        public DatabaseModificationAwareWidget createRegistrationForEntityType(ExperimentType entityType, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions, ActionContext context) {
            GenericExperimentRegistrationForm form = new GenericExperimentRegistrationForm(this.getGenericViewContext(), inputWidgetDescriptions, context, entityType);
            return new DatabaseModificationAwareWidget((Widget)form, (IDatabaseModificationObserver)form);
        }

        @Override
        public AbstractTabItemFactory createEntityEditor(final IIdAndCodeHolder identifiable) {
            return new AbstractTabItemFactory(){

                @Override
                public ITabItem create() {
                    DatabaseModificationAwareComponent component = GenericExperimentEditForm.create(ExperimentClientPlugin.this.getGenericViewContext(), identifiable);
                    return DefaultTabItem.create(this.getTabTitle(), component, ClientPluginFactory.this.getViewContext(), true);
                }

                @Override
                public String getId() {
                    return AbstractGenericEntityRegistrationForm.createId(identifiable, EntityKind.EXPERIMENT);
                }

                @Override
                public HelpPageIdentifier getHelpPageIdentifier() {
                    return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.EXPERIMENT, HelpPageIdentifier.HelpPageAction.EDIT);
                }

                @Override
                public String getTabTitle() {
                    return ExperimentClientPlugin.this.getEditorTitle("experiment", identifiable);
                }

                @Override
                public String tryGetLink() {
                    return null;
                }
            };
        }

        private String getViewerTitle(String entityKindDictKey, IIdAndCodeHolder identifiable) {
            return AbstractViewer.getTitle(ClientPluginFactory.this.getViewContext(), entityKindDictKey, identifiable);
        }

        private String getEditorTitle(String entityKindDictKey, IIdAndCodeHolder identifiable) {
            return AbstractRegistrationForm.getEditTitle(ClientPluginFactory.this.getViewContext(), entityKindDictKey, identifiable);
        }

        private IViewContext<IGenericClientServiceAsync> getGenericViewContext() {
            return new GenericViewContext(((ViewContext)ClientPluginFactory.this.getViewContext()).getCommonViewContext());
        }
    }
}

