/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ITabActionMenuItemDefinition;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TabActionMenuItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.RawDataSampleGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.wizard.MsInjectionSampleAnnotationWizard;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PhosphoNetXModule
implements IModule {
    public static final String ID = "openbis_-proteomics-";
    private final IViewContext<IPhosphoNetXClientServiceAsync> viewContext;

    public PhosphoNetXModule(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
    }

    @Override
    public List<? extends MenuItem> getMenuItems() {
        ActionMenu msInjectionSampleAnnotatingMenuItem = TabActionMenuItemFactory.createActionMenu(this.viewContext, ID, new ITabActionMenuItemDefinition<IPhosphoNetXClientServiceAsync>(){

            @Override
            public String getName() {
                return "ANNOTATE_MS_INJECTION_SAMPLES";
            }

            @Override
            public String getHelpPageTitle() {
                return "Wizard for annotation MS INJECTION samples";
            }

            @Override
            public DatabaseModificationAwareComponent createComponent(IViewContext<IPhosphoNetXClientServiceAsync> context) {
                return DatabaseModificationAwareComponent.create(new MsInjectionSampleAnnotationWizard(context));
            }

            @Override
            public String tryGetLink() {
                URLMethodWithParameters url = new URLMethodWithParameters("");
                url.addParameter("action", this.getName());
                return url.toString().substring(1);
            }
        });
        ActionMenu msInjectionSampleBrowserMenuItem = TabActionMenuItemFactory.createActionMenu(this.viewContext, ID, new ITabActionMenuItemDefinition<IPhosphoNetXClientServiceAsync>(){

            @Override
            public String getName() {
                return "ALL_RAW_DATA_SAMPLES";
            }

            @Override
            public String getHelpPageTitle() {
                return "MS INJECTION Data Overview";
            }

            @Override
            public DatabaseModificationAwareComponent createComponent(IViewContext<IPhosphoNetXClientServiceAsync> context) {
                return RawDataSampleGrid.create(context);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        });
        return Arrays.asList(msInjectionSampleAnnotatingMenuItem, msInjectionSampleBrowserMenuItem);
    }

    @Override
    public String getName() {
        return this.viewContext.getMessage("query_menu_title", new Object[0]);
    }

    @Override
    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public Collection<? extends DisposableTabContent> getSections(IEntityInformationHolderWithIdentifier entity) {
        return new ArrayList();
    }
}

