/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;

public class RawDataProcessingMenu
extends TextToolItem {
    private final IViewContext<IPhosphoNetXClientServiceAsync> viewContext;
    private final IDelegatedActionWithResult<List<TableModelRowWithObject<Sample>>> selectedDataProvider;

    public RawDataProcessingMenu(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, IDelegatedActionWithResult<List<TableModelRowWithObject<Sample>>> selectedDataProvider) {
        super(viewContext.getMessage("copy_data_sets_button_label", new Object[0]));
        this.viewContext = viewContext;
        this.selectedDataProvider = selectedDataProvider;
        IViewContext<ICommonClientServiceAsync> commonViewContext = viewContext.getCommonViewContext();
        viewContext.getCommonService().listDataStoreServices(DataStoreServiceKind.PROCESSING, (AsyncCallback<List<DatastoreServiceDescription>>)new AbstractAsyncCallback<List<DatastoreServiceDescription>>(commonViewContext){

            @Override
            public final void process(List<DatastoreServiceDescription> plugins) {
                RawDataProcessingMenu.this.createMenu(plugins);
            }
        });
    }

    private void createMenu(List<DatastoreServiceDescription> plugins) {
        Menu subMenu = new Menu();
        for (final DatastoreServiceDescription datastoreServiceDescription : plugins) {
            IActionMenuItem actionMenuItem = new IActionMenuItem(){

                @Override
                public String getMenuText(IMessageProvider messageProvider) {
                    return datastoreServiceDescription.getLabel();
                }

                @Override
                public String getMenuId() {
                    return datastoreServiceDescription.getKey();
                }
            };
            IDelegatedAction action = new IDelegatedAction(){

                @Override
                public void execute() {
                    String title = RawDataProcessingMenu.this.viewContext.getMessage("copy_data_sets_title", new Object[0]);
                    List selectedSamples = (List)RawDataProcessingMenu.this.selectedDataProvider.execute();
                    new CopyConfirmationDialog(RawDataProcessingMenu.this.viewContext, datastoreServiceDescription, selectedSamples, title).show();
                }
            };
            subMenu.add((Component)new ActionMenu(actionMenuItem, this.viewContext, action));
        }
        this.setMenu(subMenu);
    }

    private static final class CopyConfirmationDialog
    extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<Sample>>> {
        private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;
        private final List<TableModelRowWithObject<Sample>> samples;
        private final DatastoreServiceDescription datastoreServiceDescription;
        private TextField<String> dataSetTypeField;

        private CopyConfirmationDialog(IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext, DatastoreServiceDescription datastoreServiceDescription, List<TableModelRowWithObject<Sample>> samples, String title) {
            super(specificViewContext, samples, title);
            this.specificViewContext = specificViewContext;
            this.datastoreServiceDescription = datastoreServiceDescription;
            this.samples = samples;
            this.setWidth(400);
        }

        @Override
        protected String createMessage() {
            String list = "[";
            String delim = "";
            for (TableModelRow tableModelRow : this.samples) {
                list = String.valueOf(list) + delim + tableModelRow.getValues().get(0);
                delim = ", ";
            }
            list = String.valueOf(list) + "]";
            String string = this.datastoreServiceDescription.getLabel();
            return this.specificViewContext.getMessage("copy_data_sets_message", string, list);
        }

        @Override
        protected void executeConfirmedAction() {
            long[] rawDataSampleIDs = new long[this.samples.size()];
            int i = 0;
            while (i < this.samples.size()) {
                rawDataSampleIDs[i] = this.samples.get(i).getObjectOrNull().getId();
                ++i;
            }
            this.specificViewContext.getService().processRawData(this.datastoreServiceDescription.getKey(), rawDataSampleIDs, (String)this.dataSetTypeField.getValue(), new VoidAsyncCallback<Void>(this.specificViewContext));
        }

        @Override
        protected void extendForm() {
            this.dataSetTypeField = new TextField();
            this.dataSetTypeField.setFieldLabel(this.specificViewContext.getMessage("copy_data_sets_data_set_type_field", new Object[0]));
            this.dataSetTypeField.setSelectOnFocus(true);
            this.dataSetTypeField.setWidth(200);
            this.formPanel.add(this.dataSetTypeField);
            this.formPanel.setLabelWidth(100);
        }
    }
}

