/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.PhosphoNetXDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.RawDataProcessingMenu;
import java.util.List;

class RawDataSampleGrid
extends TypedTableGrid<Sample> {
    public static final String BROWSER_ID = "openbis_raw_data_sample_browser";
    private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;

    public static DatabaseModificationAwareComponent create(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
        RawDataSampleGrid grid = new RawDataSampleGrid(viewContext);
        DisposableEntityChooser disposable = grid.asDisposableWithoutToolbar();
        return new DatabaseModificationAwareComponent(disposable.getComponent(), (IDatabaseModificationObserver)disposable);
    }

    RawDataSampleGrid(IViewContext<IPhosphoNetXClientServiceAsync> viewContext) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, true, PhosphoNetXDisplayTypeIDGenerator.RAW_DATA_SAMPLE_BROWSER_GRID);
        this.specificViewContext = viewContext;
        this.allowMultipleSelection();
        this.addEntityOperationsLabel();
        RawDataProcessingMenu button = new RawDataProcessingMenu(viewContext, new IDelegatedActionWithResult<List<TableModelRowWithObject<Sample>>>(){

            @Override
            public List<TableModelRowWithObject<Sample>> execute() {
                return RawDataSampleGrid.this.getSelectedBaseObjects();
            }
        });
        this.enableButtonOnSelectedItems(button);
        this.addButton(button);
        this.linkMSInjectionSample();
        this.linkBiologicalSample();
    }

    private void linkMSInjectionSample() {
        this.registerListenerAndLinkGenerator("CODE", new ICellListenerAndLinkGenerator<Sample>(){

            @Override
            public void handle(TableModelRowWithObject<Sample> rowItem, boolean specialKeyPressed) {
                RawDataSampleGrid.this.showEntityInformationHolderViewer(rowItem.getObjectOrNull(), false, specialKeyPressed);
            }

            @Override
            public String tryGetLink(Sample entity, ISerializableComparable value) {
                return LinkExtractor.tryExtract(entity);
            }
        });
    }

    private void linkBiologicalSample() {
        this.registerListenerAndLinkGenerator("PARENT", new ICellListenerAndLinkGenerator<Sample>(){

            @Override
            public void handle(TableModelRowWithObject<Sample> rowItem, boolean specialKeyPressed) {
                RawDataSampleGrid.this.showEntityInformationHolderViewer(rowItem.getObjectOrNull().getGeneratedFrom(), false, specialKeyPressed);
            }

            @Override
            public String tryGetLink(Sample entity, ISerializableComparable comparableValue) {
                return LinkExtractor.tryExtract(entity.getGeneratedFrom());
            }
        });
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Sample>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Sample>> callback) {
        this.specificViewContext.getService().listRawDataSamples(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Sample>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.specificViewContext.getService().prepareExportRawDataSamples(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SPACE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }
}

