/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IProteomicsDataServiceInternal;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.MsInjectionSample;
import java.util.List;

class RawDataSampleProvider
extends AbstractTableModelProvider<Sample> {
    private final IProteomicsDataServiceInternal service;
    private final String sessionToken;

    RawDataSampleProvider(IProteomicsDataServiceInternal service, String sessionToken) {
        this.service = service;
        this.sessionToken = sessionToken;
    }

    @Override
    public TypedTableModel<Sample> createTableModel() {
        List<MsInjectionSample> samples = this.service.listRawDataSamples(this.sessionToken);
        TypedTableModelBuilder<Sample> builder = new TypedTableModelBuilder<Sample>();
        builder.addColumn("CODE").withDataType(DataTypeCode.VARCHAR);
        builder.addColumn("REGISTRATION_DATE").withDataType(DataTypeCode.TIMESTAMP).withDefaultWidth(190);
        builder.addColumn("PARENT").withDataType(DataTypeCode.VARCHAR);
        builder.addColumn("EXPERIMENT").withDataType(DataTypeCode.VARCHAR);
        for (MsInjectionSample msInjectionSample : samples) {
            Sample sample = msInjectionSample.getSample();
            builder.addRow(sample);
            builder.column("CODE").addString(sample.getCode());
            builder.column("REGISTRATION_DATE").addDate(sample.getRegistrationDate());
            Sample parent = sample.getGeneratedFrom();
            builder.column("PARENT").addString(parent.getIdentifier());
            Experiment experiment = parent.getExperiment();
            if (experiment != null) {
                builder.column("EXPERIMENT").addString(experiment.getIdentifier());
            }
            builder.columnGroup("MS").addProperties("", sample.getProperties());
            builder.columnGroup("BIO_").addProperties(parent.getProperties());
        }
        return builder.getModel();
    }
}

