/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.Arrays;
import java.util.List;

public class BiologicalSampleProvider
extends AbstractCommonTableModelProvider<Sample> {
    public BiologicalSampleProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<Sample> createTableModel() {
        DetailedSearchCriteria criteria = new DetailedSearchCriteria();
        criteria.setConnection(SearchCriteriaConnection.MATCH_ALL);
        DetailedSearchCriterion typeCriterion = new DetailedSearchCriterion();
        typeCriterion.setField(DetailedSearchField.createAttributeField(SampleAttributeSearchFieldKind.SAMPLE_TYPE));
        typeCriterion.setValue("BIO*");
        DetailedSearchCriterion registratorCriterion = new DetailedSearchCriterion();
        String userName = this.commonServer.tryGetSession(this.sessionToken).getUserName();
        registratorCriterion.setField(DetailedSearchField.createRegistratorField());
        registratorCriterion.setValue(userName);
        criteria.setCriteria(Arrays.asList(typeCriterion, registratorCriterion));
        List<Sample> samples = this.commonServer.searchForSamples(this.sessionToken, criteria);
        TypedTableModelBuilder<Sample> builder = new TypedTableModelBuilder<Sample>();
        builder.addColumn("IDENTIFIER");
        builder.addColumn("REGISTRATION_DATE");
        for (Sample sample : samples) {
            builder.addRow(sample);
            builder.column("IDENTIFIER").addString(sample.getIdentifier());
            builder.column("REGISTRATION_DATE").addDate(sample.getRegistrationDate());
            builder.columnGroup("PROPERTY").uneditablePropertyColumns().addProperties(sample.getProperties());
        }
        return builder.getModel();
    }
}

