/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSequence;
import java.util.List;

public class ProteinSequenceProvider
extends AbstractTableModelProvider<ProteinSequence> {
    private final IPhosphoNetXServer server;
    private final String sessionToken;
    private final TechId experimentID;
    private final TechId proteinReferenceID;

    public ProteinSequenceProvider(IPhosphoNetXServer server, String sessionToken, TechId experimentID, TechId proteinReferenceID) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.experimentID = experimentID;
        this.proteinReferenceID = proteinReferenceID;
    }

    @Override
    protected TypedTableModel<ProteinSequence> createTableModel() {
        List<ProteinSequence> sequences = this.server.listProteinSequencesByProteinReference(this.sessionToken, this.experimentID, this.proteinReferenceID);
        TypedTableModelBuilder<ProteinSequence> builder = new TypedTableModelBuilder<ProteinSequence>();
        builder.addColumn("SEQUENCE_SHORT_NAME").withDefaultWidth(20);
        builder.addColumn("DATABASE_NAME_AND_VERSION");
        builder.addColumn("SEQUENCE").withDefaultWidth(400);
        for (ProteinSequence sequence : sequences) {
            builder.addRow(sequence);
            builder.column("SEQUENCE_SHORT_NAME").addString(sequence.getShortName());
            builder.column("DATABASE_NAME_AND_VERSION").addString(sequence.getDatabaseNameAndVersion());
            builder.column("SEQUENCE").addString(sequence.getSequence());
        }
        return builder.getModel();
    }
}

