/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSummary;
import java.util.List;

public class ProteinSummaryProvider
extends AbstractTableModelProvider<ProteinSummary> {
    private final IPhosphoNetXServer server;
    private final String sessionToken;
    private final TechId experimentID;

    public ProteinSummaryProvider(IPhosphoNetXServer server, String sessionToken, TechId experimentID) {
        this.server = server;
        this.sessionToken = sessionToken;
        this.experimentID = experimentID;
    }

    @Override
    protected TypedTableModel<ProteinSummary> createTableModel() {
        List<ProteinSummary> sumaries = this.server.listProteinSummariesByExperiment(this.sessionToken, this.experimentID);
        TypedTableModelBuilder<ProteinSummary> builder = new TypedTableModelBuilder<ProteinSummary>();
        builder.addColumn("FDR");
        builder.addColumn("PROTEIN_COUNT").withDefaultWidth(100);
        builder.addColumn("PEPTIDE_COUNT").withDefaultWidth(100);
        builder.addColumn("DECOY_PROTEIN_COUNT").withDefaultWidth(100);
        builder.addColumn("DECOY_PEPTIDE_COUNT").withDefaultWidth(100);
        for (ProteinSummary summary : sumaries) {
            builder.addRow(summary);
            builder.column("FDR").addDouble(summary.getFDR());
            builder.column("PROTEIN_COUNT").addInteger(Long.valueOf(summary.getProteinCount()));
            builder.column("PEPTIDE_COUNT").addInteger(Long.valueOf(summary.getPeptideCount()));
            builder.column("DECOY_PROTEIN_COUNT").addInteger(Long.valueOf(summary.getDecoyProteinCount()));
            builder.column("DECOY_PEPTIDE_COUNT").addInteger(Long.valueOf(summary.getDecoyPeptideCount()));
        }
        return builder.getModel();
    }
}

