/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.IPhosphoNetXServer;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AggregateFunction;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.DataSetProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinByExperiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinRelatedSample;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSequence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinSummary;
import java.util.List;

public class PhosphoNetXServerLogger
extends AbstractServerLogger
implements IPhosphoNetXServer {
    PhosphoNetXServerLogger(ISessionManager<Session> sessionManager, IInvocationLoggerContext context) {
        super(sessionManager, context);
    }

    @Override
    public Vocabulary getTreatmentTypeVocabulary(String sessionToken) throws UserFailureException {
        this.logAccess(sessionToken, "get_treatment_type_vocabulary");
        return null;
    }

    @Override
    public List<AbundanceColumnDefinition> getAbundanceColumnDefinitionsForProteinByExperiment(String sessionToken, TechId experimentID, String treatmentTypeOrNull) throws UserFailureException {
        this.logAccess(sessionToken, "get_abundance_colum_definitions", "EXPERIMENT_ID(%s) TREATMENT_TYPE(%s)", experimentID, treatmentTypeOrNull);
        return null;
    }

    @Override
    public List<ProteinInfo> listProteinsByExperiment(String sessionToken, TechId experimentId, double falseDiscoveryRate, AggregateFunction function, String treatmentTypeCode, boolean aggregateOnOriginal) throws UserFailureException {
        this.logAccess(sessionToken, "list_proteins_by_experiment", "ID(%s) FDR(%s) AGGREGATE_FUNCTION(%s) TREATMENT_TYPE(%s) AGGREGATE_ON_ORIGINAL(%s)", experimentId, falseDiscoveryRate, function.getLabel(), treatmentTypeCode, aggregateOnOriginal);
        return null;
    }

    @Override
    public List<ProteinSummary> listProteinSummariesByExperiment(String sessionToken, TechId experimentId) throws UserFailureException {
        this.logAccess(sessionToken, "list_protein_summaries_by_experiment", "EXPERIMENT_ID(%s)", experimentId);
        return null;
    }

    @Override
    public ProteinByExperiment getProteinByExperiment(String sessionToken, TechId experimentId, TechId proteinReferenceID) throws UserFailureException {
        this.logAccess(sessionToken, "get_protein_by_experiment", "EXPERIMENT_ID(%s) PROTEIN_REFERENCE_ID(%s)", experimentId, proteinReferenceID);
        return null;
    }

    @Override
    public List<ProteinSequence> listProteinSequencesByProteinReference(String sessionToken, TechId experimentID, TechId proteinReferenceID) throws UserFailureException {
        this.logAccess(sessionToken, "list_protein_sequences_by_reference", "EXPERIMENT_ID(%s) PROTEIN_REFERENCE_ID(%s)", experimentID, proteinReferenceID);
        return null;
    }

    @Override
    public List<DataSetProtein> listProteinsByExperimentAndReference(String sessionToken, TechId experimentId, TechId proteinReferenceID) throws UserFailureException {
        this.logAccess(sessionToken, "list_proteins_by_experiment_and_reference", "EXPERIMENT_ID(%s) PROTEIN_REFERENCE_ID(%s)", experimentId, proteinReferenceID);
        return null;
    }

    @Override
    public List<ProteinRelatedSample> listProteinRelatedSamplesByProtein(String sessionToken, TechId experimentID, TechId proteinReferenceID) throws UserFailureException {
        this.logAccess(sessionToken, "list_protein_related_samples_by_protein", "EXPERIMENT_ID(%s) PROTEIN_REFERENCE_ID(%s)", experimentID, proteinReferenceID);
        return null;
    }
}

