/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IAbundanceColumnDefinitionTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.TreatmentFinder;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Treatment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class AbundanceColumnDefinitionTable
extends AbstractBusinessObject
implements IAbundanceColumnDefinitionTable {
    private final TreatmentFinder treatmentFinder = new TreatmentFinder();
    private final Map<Long, AbundanceColumnDefinition> columnDefinitions = new TreeMap<Long, AbundanceColumnDefinition>();

    AbundanceColumnDefinitionTable(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, Session session) {
        super(daoFactory, specificDAOFactory, session);
    }

    @Override
    public void add(Sample sample) {
        Sample parent = sample.getGeneratedFrom();
        Sample sampleOrParent = parent == null ? sample : parent;
        Long sampleID = sampleOrParent.getId();
        AbundanceColumnDefinition columnDefinition = this.columnDefinitions.get(sampleID);
        if (columnDefinition == null) {
            columnDefinition = new AbundanceColumnDefinition();
            columnDefinition.addSampleID(sampleID);
            columnDefinition.setSampleCode(sampleOrParent.getCode());
            columnDefinition.setTreatments(this.treatmentFinder.findTreatmentsOf(sampleOrParent));
            this.columnDefinitions.put(sampleID, columnDefinition);
        }
    }

    @Override
    public List<AbundanceColumnDefinition> getSortedAndAggregatedDefinitions(String treatmentTypeOrNull) {
        Collection<AbundanceColumnDefinition> values = this.columnDefinitions.values();
        ArrayList<AbundanceColumnDefinition> definitions = new ArrayList<AbundanceColumnDefinition>();
        if (treatmentTypeOrNull == null) {
            definitions.addAll(values);
        } else {
            Collection<List<AbundanceColumnDefinition>> groupedDefinitions = this.groupDefinitions(values, definitions, treatmentTypeOrNull);
            for (List<AbundanceColumnDefinition> group : groupedDefinitions) {
                AbundanceColumnDefinition definition = new AbundanceColumnDefinition();
                AbundanceColumnDefinition firstDefinition = group.get(0);
                Treatment treatment = this.tryToFindTreatmentByTypeCode(firstDefinition, treatmentTypeOrNull);
                definition.setTreatments(Arrays.asList(treatment));
                for (AbundanceColumnDefinition abundanceColumnDefinition : group) {
                    definition.addSampleIDsOf(abundanceColumnDefinition);
                }
                definitions.add(definition);
            }
        }
        Collections.sort(definitions);
        return definitions;
    }

    private Collection<List<AbundanceColumnDefinition>> groupDefinitions(Collection<AbundanceColumnDefinition> values, List<AbundanceColumnDefinition> definitions, String treatmentType) {
        HashMap<String, ArrayList<AbundanceColumnDefinition>> groupedDefinitions = new HashMap<String, ArrayList<AbundanceColumnDefinition>>();
        for (AbundanceColumnDefinition definition : values) {
            Treatment treatment = this.tryToFindTreatmentByTypeCode(definition, treatmentType);
            if (treatment == null) {
                definitions.add(definition);
                continue;
            }
            String treatmentValue = treatment.getValue();
            ArrayList<AbundanceColumnDefinition> list = (ArrayList<AbundanceColumnDefinition>)groupedDefinitions.get(treatmentValue);
            if (list == null) {
                list = new ArrayList<AbundanceColumnDefinition>();
                groupedDefinitions.put(treatmentValue, list);
            }
            list.add(definition);
        }
        return groupedDefinitions.values();
    }

    private Treatment tryToFindTreatmentByTypeCode(AbundanceColumnDefinition definition, String typeCode) {
        List<Treatment> treatments = definition.getTreatments();
        for (Treatment treatment : treatments) {
            if (!treatment.getTypeCode().equals(typeCode)) continue;
            return treatment;
        }
        return null;
    }
}

