/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AccessionNumberBuilder;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ErrorModel;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IProteinDetailsBO;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.IndistinguishableProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Peptide;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.PeptideModification;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinDetails;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.IdentifiedProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.IndistinguishableProtein;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.PeptideWithModification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.lemnik.eodsql.DataSet;

class ProteinDetailsBO
extends AbstractBusinessObject
implements IProteinDetailsBO {
    private ProteinDetails details;

    ProteinDetailsBO(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, Session session) {
        super(daoFactory, specificDAOFactory, session);
    }

    @Override
    public ProteinDetails getDetailsOrNull() {
        return this.details;
    }

    @Override
    public void loadByExperimentAndReference(TechId experimentID, TechId proteinReferenceID) {
        String experimentPermID = this.getExperimentPermIDFor(experimentID);
        IProteinQueryDAO proteinQueryDAO = this.getSpecificDAOFactory().getProteinQueryDAO(experimentID);
        DataSet<IdentifiedProtein> proteins = proteinQueryDAO.listProteinsByProteinReferenceAndExperiment(experimentPermID, proteinReferenceID.getId());
        try {
            if (proteins.size() == 1) {
                ErrorModel errorModel = new ErrorModel(proteinQueryDAO);
                IdentifiedProtein protein = (IdentifiedProtein)proteins.get(0);
                errorModel.setFalseDiscoveryRateFor(protein);
                this.details = new ProteinDetails();
                this.details.setSequence(protein.getSequence());
                this.details.setDatabaseNameAndVersion(protein.getDatabaseNameAndVersion());
                this.details.setProbability(protein.getProbability());
                this.details.setCoverage(100.0 * protein.getCoverage());
                this.details.setFalseDiscoveryRate(protein.getFalseDiscoveryRate());
                String dataSetPermID = protein.getDataSetPermID();
                this.details.setDataSetPermID(dataSetPermID);
                DataPE ds = this.getDaoFactory().getDataDAO().tryToFindDataSetByCode(dataSetPermID);
                if (ds != null) {
                    this.details.setDataSetTechID(ds.getId());
                    this.details.setDataSetTypeCode(ds.getDataSetType().getCode());
                }
                this.details.setPeptides(this.loadPeptides(proteinQueryDAO, protein));
                long proteinID = protein.getProteinID();
                this.details.setProteinID(new TechId(proteinID));
                this.details.setIndistinguishableProteinInfos(this.loadIndistinguishableProteinInfos(proteinQueryDAO, proteinID));
            }
        }
        finally {
            proteins.close();
        }
    }

    private List<IndistinguishableProteinInfo> loadIndistinguishableProteinInfos(IProteinQueryDAO proteinQueryDAO, long proteinID) {
        DataSet<IndistinguishableProtein> proteins = proteinQueryDAO.listIndistinguishableProteinsByProteinID(proteinID);
        try {
            ArrayList<IndistinguishableProteinInfo> infos = new ArrayList<IndistinguishableProteinInfo>();
            for (IndistinguishableProtein protein : proteins) {
                IndistinguishableProteinInfo info = new IndistinguishableProteinInfo();
                AccessionNumberBuilder builder = new AccessionNumberBuilder(protein.getAccessionNumber());
                info.setAccessionNumber(builder.getAccessionNumber());
                info.setAccessionNumberType(builder.getTypeOrNull());
                info.setDescription(protein.getDescription());
                info.setSequence(protein.getSequence());
                info.setCoverage(100.0 * protein.getCoverage());
                infos.add(info);
            }
            ArrayList<IndistinguishableProteinInfo> arrayList = infos;
            return arrayList;
        }
        finally {
            proteins.close();
        }
    }

    private List<Peptide> loadPeptides(IProteinQueryDAO proteinQueryDAO, IdentifiedProtein protein) {
        DataSet<PeptideWithModification> identifiedPeptides = proteinQueryDAO.listIdentifiedPeptidesByProtein(protein.getProteinID());
        try {
            HashMap<Long, Peptide> peps = new HashMap<Long, Peptide>();
            for (PeptideWithModification peptidWithModification : identifiedPeptides) {
                long id = peptidWithModification.getId();
                Peptide peptide = (Peptide)peps.get(id);
                if (peptide == null) {
                    peptide = new Peptide();
                    peptide.setSequence(peptidWithModification.getSequence());
                    peps.put(id, peptide);
                }
                Integer position = peptidWithModification.getPosition();
                Double mass = peptidWithModification.getMass();
                if (position == null || mass == null) continue;
                PeptideModification peptideModification = new PeptideModification();
                peptideModification.setPosition(position);
                peptideModification.setMass(mass);
                peptide.getModifications().add(peptideModification);
            }
            ArrayList<Peptide> result = new ArrayList<Peptide>(peps.values());
            Collections.sort(result, new Comparator<Peptide>(){

                @Override
                public int compare(Peptide p1, Peptide p2) {
                    return p1.getSequence().compareTo(p2.getSequence());
                }
            });
            ArrayList<Peptide> arrayList = result;
            return arrayList;
        }
        finally {
            identifiedPeptides.close();
        }
    }

    private String getExperimentPermIDFor(TechId experimentId) {
        ExperimentPE experiment = (ExperimentPE)this.getDaoFactory().getExperimentDAO().getByTechId(experimentId);
        return experiment.getPermId();
    }
}

