/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleTable;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.SampleIDProvider;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IPhosphoNetXDAOFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.IProteinQueryDAO;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.SampleWithPropertiesAndAbundance;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.dto.SampleAbundance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.lemnik.eodsql.DataSet;

class SampleTable
extends AbstractBusinessObject
implements ISampleTable {
    private List<SampleWithPropertiesAndAbundance> samples = new ArrayList<SampleWithPropertiesAndAbundance>();
    private SampleIDProvider sampleIDProvider;
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    SampleTable(IDAOFactory daoFactory, IPhosphoNetXDAOFactory specificDAOFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, specificDAOFactory, session);
        this.sampleIDProvider = new SampleIDProvider(daoFactory.getSampleDAO());
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public List<SampleWithPropertiesAndAbundance> getSamples() {
        return this.samples;
    }

    @Override
    public void loadSamplesWithAbundance(TechId experimentID, TechId proteinReferenceID) {
        this.samples = new ArrayList<SampleWithPropertiesAndAbundance>();
        IProteinQueryDAO proteinQueryDAO = this.getSpecificDAOFactory().getProteinQueryDAO(experimentID);
        IDAOFactory daoFactory = this.getDaoFactory();
        String experimentPermID = ((ExperimentPE)daoFactory.getExperimentDAO().getByTechId(experimentID)).getPermId();
        DataSet<SampleAbundance> sampleAbundances = proteinQueryDAO.listSampleAbundanceByProtein(experimentPermID, proteinReferenceID.getId());
        try {
            ISampleDAO sampleDAO = daoFactory.getSampleDAO();
            for (SampleAbundance sampleAbundance : sampleAbundances) {
                SampleWithPropertiesAndAbundance sample = new SampleWithPropertiesAndAbundance();
                sample.setAbundance(sampleAbundance.getAbundance());
                String samplePermID = sampleAbundance.getSamplePermID();
                long sampleID = this.sampleIDProvider.getSampleIDOrParentSampleID(samplePermID);
                SamplePE samplePE = (SamplePE)sampleDAO.getByTechId(new TechId(sampleID));
                SampleTable.fillSampleData(sample, samplePE, this.managedPropertyEvaluatorFactory);
                this.samples.add(sample);
            }
        }
        finally {
            sampleAbundances.close();
        }
    }

    private static final void fillSampleData(SampleWithPropertiesAndAbundance result, SamplePE samplePE, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        result.setId(HibernateUtils.getId(samplePE));
        result.setPermId(samplePE.getPermId());
        result.setCode(samplePE.getCode());
        result.setIdentifier(samplePE.getIdentifier());
        result.setSampleType(SampleTypeTranslator.translate(samplePE.getSampleType(), new HashMap<PropertyTypePE, PropertyType>()));
        result.setProperties(EntityPropertyTranslator.translate(samplePE.getProperties(), new HashMap<PropertyTypePE, PropertyType>(), managedPropertyEvaluatorFactory));
    }
}

