/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto;

import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Treatment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AbundanceColumnDefinition
implements Serializable,
Comparable<AbundanceColumnDefinition> {
    private static final long serialVersionUID = 35L;
    private List<Long> sampleIDs = new ArrayList<Long>(1);
    private String sampleCode;
    private List<Treatment> treatments;

    public final long getID() {
        long id = 0L;
        for (Long sampleID : this.sampleIDs) {
            id = 37L * id + sampleID;
        }
        return id;
    }

    public final List<Long> getSampleIDs() {
        return this.sampleIDs;
    }

    public final void addSampleIDsOf(AbundanceColumnDefinition definition) {
        this.sampleIDs.addAll(definition.getSampleIDs());
    }

    public final void addSampleID(long sampleID) {
        this.sampleIDs.add(sampleID);
    }

    public final String getSampleCode() {
        return this.sampleCode;
    }

    public final void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
    }

    public final List<Treatment> getTreatments() {
        return this.treatments;
    }

    public final void setTreatments(List<Treatment> treatments) {
        this.treatments = treatments;
    }

    @Override
    public int compareTo(AbundanceColumnDefinition that) {
        if (this.treatments != null && that.treatments != null) {
            int i = 0;
            int n = Math.min(this.treatments.size(), that.treatments.size());
            while (i < n) {
                Treatment thatTreatment;
                Treatment thisTreatment = this.treatments.get(i);
                int diff = thisTreatment.compareTo(thatTreatment = that.treatments.get(i));
                if (diff != 0) {
                    return diff;
                }
                ++i;
            }
            int sizeDiff = this.treatments.size() - that.treatments.size();
            if (sizeDiff != 0) {
                return sizeDiff;
            }
        }
        if (this.sampleCode != null && that.sampleCode != null) {
            return this.sampleCode.compareTo(that.sampleCode);
        }
        return 0;
    }
}

