/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto;

import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetOverlayImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.TileLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import java.util.ArrayList;
import java.util.List;

public class LogicalImageReference {
    private final String datasetCode;
    private final String datastoreCode;
    private final String datastoreHostUrl;
    private final ImageDatasetParameters imageParameters;
    private final WellLocation wellLocationOrNull;
    private final TileLocation tileLocationOrNull;
    private final List<DatasetOverlayImagesReference> overlayDatasets;

    public LogicalImageReference(ImageDatasetEnrichedReference imageEnrichedDataset, WellLocation wellLocationOrNull) {
        this(imageEnrichedDataset.getImageDataset(), imageEnrichedDataset.getOverlayDatasets(), wellLocationOrNull, null);
    }

    public LogicalImageReference(ImageDatasetEnrichedReference imageEnrichedDataset, WellLocation wellLocationOrNull, TileLocation tileLocationOrNull) {
        this(imageEnrichedDataset.getImageDataset(), imageEnrichedDataset.getOverlayDatasets(), wellLocationOrNull, tileLocationOrNull);
    }

    private LogicalImageReference(DatasetImagesReference imageDataset, List<DatasetOverlayImagesReference> overlayDatasets, WellLocation wellLocationOrNull, TileLocation tileLocationOrNull) {
        assert (imageDataset != null) : "image dataset is null";
        this.datasetCode = imageDataset.getDatasetCode();
        this.datastoreCode = imageDataset.getDatastoreCode();
        this.datastoreHostUrl = imageDataset.getDatastoreHostUrl();
        this.imageParameters = imageDataset.getImageParameters();
        this.wellLocationOrNull = wellLocationOrNull;
        this.tileLocationOrNull = tileLocationOrNull;
        this.overlayDatasets = overlayDatasets;
    }

    public LogicalImageReference(String datasetCode, String datastoreCode, String datastoreHostUrl, ImageDatasetParameters imageParameters) {
        this.datasetCode = datasetCode;
        this.datastoreCode = datastoreCode;
        this.datastoreHostUrl = datastoreHostUrl;
        this.imageParameters = imageParameters;
        this.wellLocationOrNull = null;
        this.tileLocationOrNull = null;
        this.overlayDatasets = new ArrayList<DatasetOverlayImagesReference>();
    }

    public LogicalImageReference updateDatasets(ImageDatasetEnrichedReference refreshedDataset) {
        return new LogicalImageReference(refreshedDataset, this.wellLocationOrNull, this.tileLocationOrNull);
    }

    public WellLocation tryGetWellLocation() {
        return this.wellLocationOrNull;
    }

    public TileLocation tryGetTileLocation() {
        return this.tileLocationOrNull;
    }

    public int getTileRowsNum() {
        return this.imageParameters.getTileRowsNum();
    }

    public int getTileColsNum() {
        return this.imageParameters.getTileColsNum();
    }

    public List<String> getChannelsCodes() {
        return this.imageParameters.getChannelsCodes();
    }

    public boolean isMultidimensional() {
        return this.imageParameters.isMultidimensional();
    }

    public String getDatasetCode() {
        return this.datasetCode;
    }

    public String getDatastoreHostUrl() {
        return this.datastoreHostUrl;
    }

    public String getDatastoreCode() {
        return this.datastoreCode;
    }

    public String tryGetTransformerFactorySignature(String channelCodeOrNull, String transformationCode) {
        return this.imageParameters.tryGetTransformerFactorySignature(channelCodeOrNull, transformationCode);
    }

    public List<DatasetOverlayImagesReference> getOverlayDatasets() {
        return this.overlayDatasets;
    }

    public ImageDatasetParameters getImagetParameters() {
        return this.imageParameters;
    }
}

