/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.ScreeningDisplaySettingsManager;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.IRangeCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.MinMaxAndRange;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.RangeCalculatorFactory;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.Utils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.IRangeType;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureList;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorDataset;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetEnrichedReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateMetadata;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlateLayouterModel {
    private DatasetReference datasetReference;
    private final WellData[][] wellMatrix;
    private final List<WellData> wellList;
    private final Sample plateSample;
    private final ScreeningDisplaySettingsManager displaySettingsManager;
    private ImageDatasetEnrichedReference imageDatasetOrNull;
    private List<CodeAndLabel> allFeatureNames = new ArrayList<CodeAndLabel>();
    private Set<String> availableFeatureLabels = new LinkedHashSet<String>();
    private Set<String> vocabularyFeatureLabels = new HashSet<String>();
    private List<FeatureList> featureLists = new ArrayList<FeatureList>();
    private CodeAndLabel chosenFeature;
    private IRangeType rangeType;

    public PlateLayouterModel(PlateMetadata plateMetadata, ScreeningDisplaySettingsManager displaySettingsManager) {
        this.displaySettingsManager = displaySettingsManager;
        this.plateSample = plateMetadata.getPlate();
        this.wellMatrix = PlateLayouterModel.createWellMatrix(plateMetadata);
        this.wellList = PlateLayouterModel.asList(this.wellMatrix);
    }

    public DatasetReference tryGetDatasetReference() {
        return this.datasetReference;
    }

    public WellData[][] getWellMatrix() {
        return this.wellMatrix;
    }

    public List<WellData> getWellList() {
        return this.wellList;
    }

    public ImageDatasetEnrichedReference tryGetImageDataset() {
        return this.imageDatasetOrNull;
    }

    public void setImageDataset(ImageDatasetEnrichedReference imageDataset) {
        this.imageDatasetOrNull = imageDataset;
    }

    public List<CodeAndLabel> getAllFeatureNames() {
        return this.allFeatureNames;
    }

    public List<FeatureList> getFeatureLists() {
        return this.featureLists;
    }

    public boolean isVocabularyFeature() {
        return this.vocabularyFeatureLabels.contains(this.chosenFeature.getLabel());
    }

    public boolean setChosenFeature(CodeAndLabel chosenFeature) {
        this.chosenFeature = chosenFeature;
        this.setRangeType(this.displaySettingsManager.getHeatMapRangeType(chosenFeature.getCode()));
        return this.availableFeatureLabels.contains(chosenFeature.getLabel());
    }

    public CodeAndLabel getChosenFeature() {
        return this.chosenFeature;
    }

    public void setRangeType(IRangeType rangeType) {
        this.rangeType = rangeType;
        if (this.chosenFeature != null) {
            this.displaySettingsManager.setHeatMapRangeType(this.chosenFeature.getCode(), rangeType);
        }
    }

    public IRangeType getRangeType() {
        return this.rangeType;
    }

    public MinMaxAndRange calculateRange() {
        IRangeCalculator calculator = RangeCalculatorFactory.create(this.rangeType);
        ArrayList<Float> data = new ArrayList<Float>();
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        String featureKey = this.chosenFeature.getLabel();
        for (WellData wellData : this.wellList) {
            Float value = Utils.tryAsFloatFeature(wellData, featureKey);
            if (value == null || Float.isNaN(value.floatValue()) || Float.isInfinite(value.floatValue())) continue;
            data.add(value);
            min = Math.min(min, value.floatValue());
            max = Math.max(max, value.floatValue());
        }
        return new MinMaxAndRange(min, max, calculator.calculate(data));
    }

    public List<String> extractUniqueVocabularyTerms() {
        HashSet<String> uniqueValues = new HashSet<String>();
        for (WellData well : this.wellList) {
            String term = Utils.tryAsVocabularyFeature(well, this.chosenFeature.getLabel());
            if (term == null) continue;
            uniqueValues.add(term);
        }
        ArrayList<String> result = new ArrayList<String>(uniqueValues);
        Collections.sort(result);
        return result;
    }

    public void setFeatureVectorDataset(FeatureVectorDataset featureVectorDatasetOrNull) {
        this.cleanFeatureVectors();
        this.datasetReference = null;
        if (featureVectorDatasetOrNull != null) {
            List<? extends FeatureVectorValues> features;
            this.datasetReference = featureVectorDatasetOrNull.getDatasetReference();
            this.allFeatureNames.addAll(featureVectorDatasetOrNull.getFeatureNames());
            if (featureVectorDatasetOrNull.getFeatureLists() != null) {
                this.featureLists.addAll(featureVectorDatasetOrNull.getFeatureLists());
            }
            if (!(features = featureVectorDatasetOrNull.getDatasetFeatures()).isEmpty()) {
                this.vocabularyFeatureLabels = PlateLayouterModel.extractVocabularyFeatureLabels(features.get(0));
            }
            for (FeatureVectorValues featureVectorValues : features) {
                WellLocation loc = featureVectorValues.getWellLocation();
                WellData wellData = this.tryGetWellData(loc);
                if (wellData == null) continue;
                for (Map.Entry<String, FeatureValue> entry : featureVectorValues.getFeatureMap().entrySet()) {
                    String featureLabel = entry.getKey();
                    this.availableFeatureLabels.add(featureLabel);
                    FeatureValue value = entry.getValue();
                    wellData.addFeatureValue(featureLabel, value);
                }
            }
        }
    }

    private void cleanFeatureVectors() {
        this.vocabularyFeatureLabels.clear();
        this.availableFeatureLabels.clear();
        this.allFeatureNames.clear();
        this.featureLists.clear();
        for (WellData well : this.wellList) {
            well.resetFeatureValues();
        }
    }

    public void updateFeatureVectorDataset(FeatureVectorDataset featureVectorDataset) {
        assert (this.datasetReference.getCode().equals(featureVectorDataset.getDatasetReference().getCode()));
        List<? extends FeatureVectorValues> features = featureVectorDataset.getDatasetFeatures();
        if (!features.isEmpty()) {
            this.vocabularyFeatureLabels.addAll(PlateLayouterModel.extractVocabularyFeatureLabels(features.get(0)));
        }
        for (FeatureVectorValues featureVectorValues : features) {
            WellLocation loc = featureVectorValues.getWellLocation();
            WellData wellData = this.tryGetWellData(loc);
            if (wellData == null || wellData.isFullyLoaded()) continue;
            for (Map.Entry<String, FeatureValue> entry : featureVectorValues.getFeatureMap().entrySet()) {
                String featureLabel = entry.getKey();
                this.availableFeatureLabels.add(featureLabel);
                FeatureValue value = entry.getValue();
                wellData.addFeatureValue(featureLabel, value);
            }
        }
    }

    public void resetFeatureValues(WellData wellData) {
        wellData.resetFeatureValues();
    }

    public void updateWellFeatureValues(FeatureVectorValues wellFeatureVectorValues) {
        assert (this.datasetReference.getCode().equals(wellFeatureVectorValues.getDataSetCode()));
        WellLocation loc = wellFeatureVectorValues.getWellLocation();
        WellData wellData = this.tryGetWellData(loc);
        if (wellData != null) {
            Map<String, FeatureValue> allValues = wellFeatureVectorValues.getFeatureMap();
            wellData.setAllFeatureValues(allValues);
        }
    }

    private static Set<String> extractVocabularyFeatureLabels(FeatureVectorValues featureVector) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, FeatureValue> entry : featureVector.getFeatureMap().entrySet()) {
            String featureLabel = entry.getKey();
            FeatureValue featureValue = entry.getValue();
            if (!featureValue.isVocabularyTerm()) continue;
            result.add(featureLabel);
        }
        return result;
    }

    private WellData tryGetWellData(WellLocation loc) {
        int rowIx = loc.getRow() - 1;
        int colIx = loc.getColumn() - 1;
        if (rowIx < this.wellMatrix.length && colIx < this.wellMatrix[rowIx].length) {
            return this.wellMatrix[rowIx][colIx];
        }
        return null;
    }

    private static WellData[][] createWellMatrix(PlateMetadata plateMetadata) {
        WellData[][] matrix = PlateLayouterModel.createEmptyWellMatrix(plateMetadata);
        List<WellMetadata> wells = plateMetadata.getWells();
        for (WellMetadata well : wells) {
            WellLocation location = well.tryGetLocation();
            if (location == null) continue;
            WellData wellData = matrix[location.getRow() - 1][location.getColumn() - 1];
            wellData.setMetadata(well);
        }
        return matrix;
    }

    private static WellData[][] createEmptyWellMatrix(PlateMetadata plateMetadata) {
        WellData[][] data = new WellData[plateMetadata.getRowsNum()][plateMetadata.getColsNum()];
        Experiment experiment = plateMetadata.getPlate().getExperiment();
        int row = 0;
        while (row < data.length) {
            int col = 0;
            while (col < data[row].length) {
                data[row][col] = new WellData(new WellLocation(row + 1, col + 1), experiment);
                ++col;
            }
            ++row;
        }
        return data;
    }

    private static <T> List<T> asList(T[][] matrix) {
        ArrayList<T> result = new ArrayList<T>();
        int row = 0;
        while (row < matrix.length) {
            int col = 0;
            while (col < matrix[row].length) {
                result.add(matrix[row][col]);
                ++col;
            }
            ++row;
        }
        return result;
    }

    public Sample getPlateSample() {
        return this.plateSample;
    }
}

