/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.image;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.PlateStyleSetter;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.ImageDatasetChannel;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageChannelsReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.dto.LogicalImageReference;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.image.ImageInitializer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.IntensityRange;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.reveregroup.gwt.imagepreloader.FitImage;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Image
extends LayoutContainer {
    private ImageInitializer initializer;

    public Image(ImageInitializer initializer) {
        this.initializer = initializer;
        PlateStyleSetter.setPointerCursor((Component)this);
        this.setHeight(String.valueOf(this.getInitializer().getImageHeight()));
        this.add((Widget)this.createImage());
    }

    protected URLMethodWithParameters createUrl() {
        URLMethodWithParameters url = Image.createBasicImageURL(this.getInitializer().getSessionId(), this.getInitializer().getChannelReferences());
        if (this.getInitializer().getChannelReferences().tryGetImageTransformationCode() != null) {
            if ("$USER_DEFINED_RESCALING$".equalsIgnoreCase(this.getInitializer().getChannelReferences().tryGetImageTransformationCode())) {
                Map<String, IntensityRange> rangesOrNull = this.getInitializer().getChannelReferences().tryGetIntensityRanges();
                if (rangesOrNull != null) {
                    for (Map.Entry<String, IntensityRange> range : rangesOrNull.entrySet()) {
                        String suffix = "";
                        if (range.getValue() != null) {
                            suffix = "(" + range.getValue().getBlackPoint() + "," + range.getValue().getWhitePoint() + ")";
                        }
                        if (rangesOrNull.size() == 1) {
                            url.addParameter("transformation", String.valueOf(this.getInitializer().getChannelReferences().tryGetImageTransformationCode()) + suffix);
                            continue;
                        }
                        url.addParameter("transformation" + range.getKey(), String.valueOf(this.getInitializer().getChannelReferences().tryGetImageTransformationCode()) + suffix);
                    }
                }
            } else {
                url.addParameter("transformation", this.getInitializer().getChannelReferences().tryGetImageTransformationCode());
            }
        }
        Image.addImageTransformerSignature(url, this.getInitializer().getChannelReferences());
        return url;
    }

    protected URLMethodWithParameters createThumbnailImageUrl() {
        URLMethodWithParameters url = this.createUrl();
        Image.addThumbnailSize(url, this.getInitializer().getImageWidth(), this.getInitializer().getImageHeight());
        return url;
    }

    protected URLMethodWithParameters createOriginalImageUrl() {
        return this.createUrl();
    }

    protected FitImage createImage() {
        final FitImage image = new FitImage();
        image.setFixedHeight(Integer.valueOf(this.getInitializer().getImageHeight()));
        if (this.getInitializer().getImageLoadHandler() != null) {
            image.addFitImageLoadHandler(this.getInitializer().getImageLoadHandler());
        }
        final String originalImageUrl = this.createOriginalImageUrl().toString();
        final String thumbnailImageUrl = this.createThumbnailImageUrl().toString();
        image.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Image.this.getInitializer().getImageClickHandler() != null) {
                    Image.this.getInitializer().getImageClickHandler().onClick(Image.this.getInitializer().getChannelReferences(), Image.this.getInitializer().getImageRow(), Image.this.getInitializer().getImageColumn());
                } else {
                    Window.open((String)originalImageUrl, (String)"_blank", (String)"");
                }
            }
        });
        GWTUtils.executeDelayed(new IDelegatedAction(){

            @Override
            public void execute() {
                image.setUrl(thumbnailImageUrl);
            }
        });
        return image;
    }

    private static void addThumbnailSize(URLMethodWithParameters url, int width, int height) {
        url.addParameter("mode", "thumbnail" + width + "x" + height);
    }

    private static void addImageTransformerSignature(URLMethodWithParameters url, LogicalImageChannelsReference channelReferences) {
        LogicalImageReference images = channelReferences.getBasicImage();
        List<String> channels = channelReferences.getChannelCodes();
        if (channels != null) {
            for (String channel : channels) {
                String signature;
                String channelOrNull = channel;
                if (channelOrNull.equalsIgnoreCase("Merged Channels")) {
                    channelOrNull = null;
                }
                if ((signature = images.tryGetTransformerFactorySignature(channelOrNull, channelReferences.tryGetImageTransformationCode())) == null) continue;
                url.addParameter("transformerFactorySignature", signature);
            }
        }
    }

    private static URLMethodWithParameters createBasicImageURL(String sessionID, LogicalImageChannelsReference channelReferences) {
        LogicalImageReference images = channelReferences.getBasicImage();
        URLMethodWithParameters methodWithParameters = new URLMethodWithParameters(String.valueOf(images.getDatastoreHostUrl()) + "/" + "datastore_server_screening");
        methodWithParameters.addParameter("sessionID", sessionID);
        methodWithParameters.addParameter("dataset", images.getDatasetCode());
        List<String> channels = channelReferences.getChannelCodes();
        if (channels.contains("Merged Channels")) {
            methodWithParameters.addParameter("mergeChannels", "true");
        } else {
            for (String channel : channelReferences.getChannelCodes()) {
                methodWithParameters.addParameter("channel", channel);
            }
        }
        Image.addOverlayParameters(channelReferences.getOverlayChannels(), methodWithParameters);
        return methodWithParameters;
    }

    private static void addOverlayParameters(Set<ImageDatasetChannel> overlayChannels, URLMethodWithParameters methodWithParameters) {
        for (ImageDatasetChannel overlayChannel : overlayChannels) {
            String paramName = "overlayChannel-" + overlayChannel.getDatasetCode();
            methodWithParameters.addParameter(paramName, overlayChannel.getChannelCode());
        }
    }

    protected ImageInitializer getInitializer() {
        return this.initializer;
    }
}

