/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.utils;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.util.Rectangle;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

public class GuiUtils {
    public static void replaceLastItem(LayoutContainer container, Widget newLastWidget) {
        int lastItemIx = container.getItemCount() - 1;
        if (lastItemIx >= 0) {
            container.remove(container.getWidget(lastItemIx));
            container.insert(newLastWidget, lastItemIx);
        } else {
            container.insert(newLastWidget, 0);
        }
        container.layout();
    }

    public static Widget withLabel(Widget component, String label) {
        return GuiUtils.withLabel(component, label, 0);
    }

    public static Component withLabel(Widget component, String label, int margin, int width) {
        LayoutContainer c = new LayoutContainer();
        c.setLayout((Layout)new TableLayout(2));
        TableData cellLayout = new TableData();
        cellLayout.setMargin(margin);
        Text labelWidget = new Text(label);
        if (width != -1) {
            labelWidget.setWidth(width);
        } else {
            labelWidget.setWidth(Math.max(label.length() * 9, 80));
        }
        c.add((Widget)labelWidget, (LayoutData)cellLayout);
        c.add(component);
        return c;
    }

    public static Component withLabel(Widget component, String label, int margin) {
        return GuiUtils.withLabel(component, label, margin, -1);
    }

    public static Component renderInRow(Widget ... widgets) {
        LayoutContainer c = new LayoutContainer();
        c.setLayout((Layout)new TableLayout(widgets.length * 2 - 1));
        TableData cellLayout = new TableData();
        cellLayout.setMargin(5);
        Widget[] widgetArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (c.getItems().size() > 0) {
                Html separator = new Html();
                separator.setWidth(10);
                c.add((Widget)separator);
            }
            c.add(widget, (LayoutData)cellLayout);
            ++n2;
        }
        return c;
    }

    public static Rectangle calculateBounds(Element element) {
        Rectangle rectangle = null;
        if (element != null) {
            El el = new El(element);
            rectangle = el.getBounds(false, false);
            int i = 0;
            int n = element.getChildCount();
            while (i < n) {
                rectangle = GuiUtils.merge(rectangle, GuiUtils.calculateBounds(el.getChildElement(i)));
                ++i;
            }
        }
        return rectangle;
    }

    private static Rectangle merge(Rectangle r1OrNull, Rectangle r2OrNull) {
        if (r1OrNull == null) {
            return r2OrNull == null ? null : r2OrNull;
        }
        if (r2OrNull == null) {
            return r1OrNull;
        }
        int minX1 = r1OrNull.x;
        int minY1 = r1OrNull.y;
        int maxX1 = minX1 + r1OrNull.width;
        int maxY1 = minY1 + r1OrNull.height;
        int minX2 = r2OrNull.x;
        int minY2 = r2OrNull.y;
        int maxX2 = minX2 + r2OrNull.width;
        int maxY2 = minY2 + r2OrNull.height;
        int minX = Math.min(minX1, minX2);
        int maxX = Math.max(maxX1, maxX2);
        int minY = Math.min(minY1, minY2);
        int maxY = Math.max(maxY1, maxY2);
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

