/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.HCSImageDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

class FeatureVectorDatasetLoader
extends HCSImageDatasetLoader {
    private final String featureVectorDatasetTypeCode;
    private final WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria;
    private Collection<AbstractExternalData> featureVectorDatasets;

    FeatureVectorDatasetLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, String homeSpaceOrNull, Set<? extends PlateIdentifier> plates) {
        this(session, businessObjectFactory, homeSpaceOrNull, plates, WellSearchCriteria.AnalysisProcedureCriteria.createAllProcedures());
    }

    FeatureVectorDatasetLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, String homeSpaceOrNull, Set<? extends PlateIdentifier> plates, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        super(session, businessObjectFactory, homeSpaceOrNull, plates, "HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)", "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*");
        this.featureVectorDatasetTypeCode = "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*";
        this.analysisProcedureCriteria = analysisProcedureCriteria;
    }

    public Collection<AbstractExternalData> getFeatureVectorDatasets() {
        this.loadAll();
        return this.featureVectorDatasets;
    }

    public List<FeatureVectorDatasetReference> getFeatureVectorDatasetReferences() {
        this.loadAll();
        return this.asFeatureVectorDatasetReferences();
    }

    private void loadAll() {
        this.load();
        this.loadFeatureVectorDatasets();
    }

    private void loadFeatureVectorDatasets() {
        HashMap<Long, AbstractExternalData> featureVectorDatasetSet = new HashMap<Long, AbstractExternalData>();
        ArrayList<AbstractExternalData> imageDatasets = new ArrayList<AbstractExternalData>();
        for (AbstractExternalData dataset : this.getDatasets()) {
            if (this.isMatchingAnalysisDataSet(dataset)) {
                featureVectorDatasetSet.put(dataset.getId(), dataset);
                continue;
            }
            if (!this.isMatchingImageDataset(dataset)) continue;
            imageDatasets.add(dataset);
        }
        IDatasetLister datasetLister = this.createDatasetLister();
        this.enrichWithParentDatasets(featureVectorDatasetSet.values(), imageDatasets, this.featureVectorDatasetTypeCode, datasetLister);
        List<AbstractExternalData> childrenDatasets = this.fetchChildrenDataSets(imageDatasets, this.featureVectorDatasetTypeCode, datasetLister);
        for (AbstractExternalData dataset : childrenDatasets) {
            if (!this.isMatchingAnalysisDataSet(dataset)) continue;
            featureVectorDatasetSet.put(dataset.getId(), dataset);
        }
        this.featureVectorDatasets = featureVectorDatasetSet.values();
    }

    private boolean isMatchingImageDataset(AbstractExternalData dataset) {
        return ScreeningUtils.isTypeMatching(dataset, "HCS_IMAGE($|[^_].*|_[^A].*|_A[^N].*|_AN[^A].*)");
    }

    private boolean isMatchingAnalysisDataSet(AbstractExternalData dataset) {
        return ScreeningUtils.isTypeMatching(dataset, "HCS_IMAGE_ANALYSIS_DATA|HCS_ANALYSIS_WELL.*|HCS_ANALYSIS_CONTAINER_WELL.*") && ScreeningUtils.isMatchingAnalysisProcedure(dataset, this.analysisProcedureCriteria);
    }

    private List<FeatureVectorDatasetReference> asFeatureVectorDatasetReferences() {
        ArrayList<FeatureVectorDatasetReference> result = new ArrayList<FeatureVectorDatasetReference>();
        for (AbstractExternalData externalData : this.featureVectorDatasets) {
            result.add(this.asFeatureVectorDataset(externalData));
        }
        return result;
    }

    private static AbstractExternalData tryGetOneParent(AbstractExternalData externalData) {
        Collection<AbstractExternalData> parents = externalData.getParents();
        if (parents != null && parents.size() == 1) {
            return parents.iterator().next();
        }
        return null;
    }

    protected FeatureVectorDatasetReference asFeatureVectorDataset(AbstractExternalData externalData) {
        String dataSetTypeCodeOrNull;
        DataStore dataStore = externalData.getDataStore();
        AbstractExternalData parentDataset = FeatureVectorDatasetLoader.tryGetOneParent(externalData);
        DataSetType dataSetType = externalData.getDataSetType();
        String string = dataSetTypeCodeOrNull = dataSetType == null ? null : dataSetType.getCode();
        if (parentDataset == null) {
            return new FeatureVectorDatasetReference(externalData.getCode(), dataSetTypeCodeOrNull, FeatureVectorDatasetLoader.getDataStoreUrlFromDataStore(dataStore), this.createPlateIdentifier(externalData), FeatureVectorDatasetLoader.createExperimentIdentifier(externalData), this.extractPlateGeometry(externalData), externalData.getRegistrationDate(), null, this.extractProperties(externalData));
        }
        return new FeatureVectorDatasetReference(externalData.getCode(), dataSetTypeCodeOrNull, FeatureVectorDatasetLoader.getDataStoreUrlFromDataStore(dataStore), this.createPlateIdentifier(parentDataset), FeatureVectorDatasetLoader.createExperimentIdentifier(externalData), this.extractPlateGeometry(parentDataset), externalData.getRegistrationDate(), this.tryAsImageDataset(parentDataset), this.extractProperties(externalData));
    }

    public static class FeatureVectorExternalData {
        private final AbstractExternalData featureVectorDataset;
        private final AbstractExternalData imageDatasetOrNull;

        public FeatureVectorExternalData(AbstractExternalData featureVectorDataset, AbstractExternalData imageDatasetOrNull) {
            this.featureVectorDataset = featureVectorDataset;
            this.imageDatasetOrNull = imageDatasetOrNull;
        }

        public AbstractExternalData getFeatureVectorDataset() {
            return this.featureVectorDataset;
        }

        public AbstractExternalData tryGetImageDataset() {
            return this.imageDatasetOrNull;
        }
    }
}

