/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.cli.AbstractExecutor;
import ch.systemsx.cisd.cina.client.util.cli.BundleDownloader;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CommandGetBundle
extends AbstractCinaCommand<CommandGetBundleArguments> {
    public CommandGetBundle() {
        super(new CommandGetBundleArguments());
    }

    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new GetBundleExecutor(this).execute(args);
    }

    public String getName() {
        return "getbundle";
    }

    protected String getRequiredArgumentsString() {
        return "<grid identifier> [<replica identifier> ...]";
    }

    static class CommandGetBundleArguments
    extends GlobalArguments {
        @Option(name="o", longName="output", usage="Path for output")
        private String output = "";

        CommandGetBundleArguments() {
        }

        public String tryBundleMetadataOwnerIdentifier() {
            String replicaId = (String)this.getArguments().get(0);
            if (replicaId.length() > 0) {
                return replicaId.toUpperCase();
            }
            return null;
        }

        public ArrayList<String> getReplicaIdentifiers() {
            ArrayList<String> replicaIds = new ArrayList<String>();
            List args = this.getArguments();
            int size = args.size();
            int i = 1;
            while (i < size) {
                String replicaId = (String)args.get(i);
                if (replicaId.length() > 0) {
                    replicaIds.add(replicaId.toUpperCase());
                }
                ++i;
            }
            return replicaIds;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean allAdditionalMandatoryArgumentsPresent() {
            if (this.getArguments().size() < 1) {
                return false;
            }
            return this.tryBundleMetadataOwnerIdentifier() != null;
        }
    }

    private static class GetBundleExecutor
    extends AbstractExecutor<CommandGetBundleArguments> {
        GetBundleExecutor(CommandGetBundle command) {
            super(command);
        }

        @Override
        protected ResultCode doExecute(ICinaUtilities component) {
            File outputDir = this.getOutputDir();
            outputDir.mkdirs();
            String gridIdentifier = ((CommandGetBundleArguments)this.arguments).tryBundleMetadataOwnerIdentifier();
            ArrayList<String> replicaIdentifiers = ((CommandGetBundleArguments)this.arguments).getReplicaIdentifiers();
            BundleDownloader downloader = new BundleDownloader(component, gridIdentifier, replicaIdentifiers, outputDir);
            downloader.download();
            return ResultCode.OK;
        }

        private File getOutputDir() {
            File outputDir;
            if (((CommandGetBundleArguments)this.arguments).getOutput().length() > 0) {
                outputDir = new File(((CommandGetBundleArguments)this.arguments).getOutput());
            } else {
                String gridId = ((CommandGetBundleArguments)this.arguments).tryBundleMetadataOwnerIdentifier();
                String[] gridIdComponents = gridId.split("/");
                String bundleName = gridIdComponents[gridIdComponents.length - 1];
                outputDir = new File(bundleName);
            }
            return outputDir;
        }
    }
}

