/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.cli.AbstractExecutor;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import java.util.List;
import java.util.Map;

public class CommandSampleLister
extends AbstractCinaCommand<CommandListSamplesArguments> {
    public CommandSampleLister() {
        super(new CommandListSamplesArguments());
    }

    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new SampleListerExecutor(this).execute(args);
    }

    public String getName() {
        return "listsamps";
    }

    protected String getRequiredArgumentsString() {
        return "[<sample type code>]";
    }

    static class CommandListSamplesArguments
    extends GlobalArguments {
        CommandListSamplesArguments() {
        }

        public String getSampleTypeCode() {
            if (this.getArguments().size() < 1) {
                return "GRID_REPLICA";
            }
            String sampleTypeCode = (String)this.getArguments().get(0);
            if (sampleTypeCode.length() > 0) {
                return sampleTypeCode.toUpperCase();
            }
            return "GRID_REPLICA";
        }

        public boolean allAdditionalMandatoryArgumentsPresent() {
            return this.getSampleTypeCode() != null;
        }
    }

    private static class SampleListerExecutor
    extends AbstractExecutor<CommandListSamplesArguments> {
        private static final String FIELD_SEPARATOR = "\t";

        SampleListerExecutor(CommandSampleLister command) {
            super(command);
        }

        @Override
        protected ResultCode doExecute(ICinaUtilities component) {
            SearchCriteria searchCriteria = new SearchCriteria();
            searchCriteria.addMatchClause(SearchCriteria.MatchClause.createAttributeMatch((SearchCriteria.MatchClauseAttribute)SearchCriteria.MatchClauseAttribute.TYPE, (String)((CommandListSamplesArguments)this.arguments).getSampleTypeCode()));
            List<Sample> results = component.searchForSamples(searchCriteria);
            this.printHeader();
            this.printResults(results);
            return ResultCode.OK;
        }

        private void printHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append("EXPERIMENT");
            sb.append(FIELD_SEPARATOR);
            sb.append("SAMPLE");
            sb.append(FIELD_SEPARATOR);
            sb.append("TYPE");
            sb.append(FIELD_SEPARATOR);
            sb.append("COLLECTION_NAME");
            sb.append(FIELD_SEPARATOR);
            sb.append("CREATOR_EMAIL");
            sb.append(FIELD_SEPARATOR);
            sb.append("DESCRIPTION");
            System.out.println(sb.toString());
        }

        private void printResults(List<Sample> results) {
            for (Sample sample : results) {
                StringBuilder sb = new StringBuilder();
                String experimentId = sample.getExperimentIdentifierOrNull();
                if (experimentId != null) {
                    sb.append(experimentId);
                }
                sb.append(FIELD_SEPARATOR);
                sb.append(sample.getIdentifier());
                sb.append(FIELD_SEPARATOR);
                sb.append(sample.getSampleTypeCode());
                sb.append(FIELD_SEPARATOR);
                Map properties = sample.getProperties();
                String propValue = (String)properties.get("COLLECTION_NAME");
                if (propValue != null) {
                    sb.append(propValue);
                }
                sb.append(FIELD_SEPARATOR);
                propValue = (String)properties.get("CREATOR_EMAIL");
                if (propValue != null) {
                    sb.append(propValue);
                }
                sb.append(FIELD_SEPARATOR);
                propValue = (String)properties.get("DESCRIPTION");
                if (propValue != null) {
                    sb.append(propValue);
                }
                System.out.println(sb.toString());
            }
        }
    }
}

