/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle;

import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.dss.bundle.registrators.GridPreparationRegistrator;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.etlserver.IDataSetHandlerRpc;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class CinaBundleDataSetHandler
implements IDataSetHandler {
    private final IDataSetHandler delegator;
    private final BundleRegistrationState bundleRegistrationState;

    public CinaBundleDataSetHandler(Properties parentProperties, IDataSetHandler delegator, IEncapsulatedOpenBISService openbisService) {
        this.delegator = delegator;
        this.bundleRegistrationState = delegator instanceof IDataSetHandlerRpc ? CinaBundleDataSetHandler.createBundleRegistrationState((IDataSetHandlerRpc)delegator, openbisService) : null;
    }

    public List<DataSetInformation> handleDataSet(File dataSet) {
        if (this.delegator instanceof IDataSetHandlerRpc) {
            GridPreparationRegistrator registrator = new GridPreparationRegistrator(this.bundleRegistrationState, dataSet);
            registrator.register();
            return registrator.getDataSetInformation();
        }
        return this.delegator.handleDataSet(dataSet);
    }

    private static BundleRegistrationState createBundleRegistrationState(IDataSetHandlerRpc delegator, IEncapsulatedOpenBISService openbisService) {
        return new BundleRegistrationState(delegator, openbisService);
    }
}

