/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleDataSetHelper;
import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.dss.bundle.registrators.CollectionAnnotatedImagesRegistrator;
import ch.systemsx.cisd.cina.dss.bundle.registrators.CollectionMetadataRegistrator;
import ch.systemsx.cisd.cina.dss.bundle.registrators.CollectionRawImagesRegistrator;
import ch.systemsx.cisd.cina.shared.metadata.CollectionMetadataExtractor;
import ch.systemsx.cisd.cina.shared.metadata.ImageMetadataExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CollectionRegistrator
extends BundleDataSetHelper {
    private static final String COLLECTIONS_FOLDER_NAME = "Collections";
    private static final String RAW_IMAGES_FOLDER_NAME = "RawData";
    private final CollectionMetadataExtractor collectionMetadataExtractor;
    private final Sample gridPrepSample;
    private final SampleIdentifier gridPrepSampleId;
    private final DataSetInformation bundleMetadataDataSetInformation;
    private SampleIdentifier collectionSampleId;
    private Sample collectionSample;
    private boolean didCreateSample = false;

    CollectionRegistrator(BundleRegistrationState globalState, CollectionMetadataExtractor replicaMetadataExtractor, Sample gridPrepSample, SampleIdentifier gridPrepSampleId, DataSetInformation bundleMetadataDataSetInformation, File dataSet) {
        super(globalState, dataSet);
        this.collectionMetadataExtractor = replicaMetadataExtractor;
        this.gridPrepSample = gridPrepSample;
        this.gridPrepSampleId = gridPrepSampleId;
        this.bundleMetadataDataSetInformation = bundleMetadataDataSetInformation;
    }

    public List<DataSetInformation> register() {
        this.retrieveOrCreateReplicaSample();
        if (this.didCreateSample) {
            this.registerRawImages();
        }
        File registeredDataSetFile = this.registerMetadata();
        this.registerAnnotatedImages(registeredDataSetFile);
        return this.getDataSetInformation();
    }

    private void retrieveOrCreateReplicaSample() {
        EntityProperty prop;
        String sampleCode = this.collectionMetadataExtractor.tryReplicaSampleCode();
        this.collectionSampleId = new SampleIdentifier(this.gridPrepSampleId.getSpaceLevel(), sampleCode);
        this.collectionSample = this.getOpenbisService().tryGetSampleWithExperiment(this.collectionSampleId);
        this.didCreateSample = false;
        String sampleDescriptionOrNull = this.collectionMetadataExtractor.tryReplicaSampleDescription();
        String sampleCreatorOrNull = this.collectionMetadataExtractor.tryReplicaSampleCreatorName();
        ArrayList<IEntityProperty> properties = new ArrayList<IEntityProperty>();
        if (sampleDescriptionOrNull != null) {
            prop = this.createProperty("DESCRIPTION");
            prop.setValue(sampleDescriptionOrNull);
            properties.add((IEntityProperty)prop);
        }
        if (sampleCreatorOrNull != null) {
            prop = this.createProperty("CREATOR_EMAIL");
            prop.setValue(sampleCreatorOrNull);
            properties.add((IEntityProperty)prop);
        }
        if (this.collectionSample == null) {
            this.addCollectionNamePoperty(properties);
            NewSample newSample = NewSample.createWithParent((String)this.collectionSampleId.toString(), (SampleType)this.globalState.getReplicaSampleType(), null, (String)this.gridPrepSampleId.toString());
            newSample.setExperimentIdentifier(this.gridPrepSample.getExperiment().getIdentifier());
            newSample.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
            String userId = this.getSessionContext().getUserName();
            this.getOpenbisService().registerSample(newSample, userId);
            this.didCreateSample = true;
        } else {
            ExperimentIdentifier experimentId = new ExperimentIdentifier(this.collectionSample.getExperiment());
            experimentId.setDatabaseInstanceCode(this.collectionSample.getExperiment().getProject().getSpace().getInstance().getCode());
            SampleUpdatesDTO sampleUpdate = new SampleUpdatesDTO(TechId.create((IIdHolder)this.collectionSample), properties, experimentId, new ArrayList(), this.collectionSample.getVersion(), this.collectionSampleId, null, null);
            this.getOpenbisService().updateSample(sampleUpdate);
            this.didCreateSample = false;
        }
        this.collectionSample = this.getOpenbisService().tryGetSampleWithExperiment(this.collectionSampleId);
        assert (this.collectionSample != null);
    }

    private void addCollectionNamePoperty(ArrayList<IEntityProperty> properties) {
        boolean isCollectionNameAssigned = false;
        for (SampleTypePropertyType assignedPropertyType : this.globalState.getReplicaSampleType().getAssignedPropertyTypes()) {
            if (!"COLLECTION_NAME".equals(assignedPropertyType.getPropertyType().getCode())) continue;
            isCollectionNameAssigned = true;
            break;
        }
        if (!isCollectionNameAssigned) {
            return;
        }
        String collectionName = this.collectionMetadataExtractor.getCollectionName();
        EntityProperty collectionNameProperty = this.createProperty("COLLECTION_NAME");
        collectionNameProperty.setValue(collectionName);
        properties.add((IEntityProperty)collectionNameProperty);
    }

    private void registerRawImages() {
        String collectionName = this.collectionMetadataExtractor.getCollectionName();
        System.out.println("COllectionName: " + collectionName);
        File collectionOriginalImages = new File(new File(new File(this.dataSet, COLLECTIONS_FOLDER_NAME), collectionName), RAW_IMAGES_FOLDER_NAME);
        CollectionRawImagesRegistrator registrator = new CollectionRawImagesRegistrator(this.globalState, this.collectionMetadataExtractor, this.collectionSample, this.collectionSampleId, collectionOriginalImages);
        List<DataSetInformation> registeredDataSetInfos = registrator.register();
        this.getDataSetInformation().addAll(registeredDataSetInfos);
    }

    private File registerMetadata() {
        CollectionMetadataRegistrator registrator = new CollectionMetadataRegistrator(this.globalState, this.collectionMetadataExtractor, this.collectionSample, this.collectionSampleId, this.bundleMetadataDataSetInformation);
        List<DataSetInformation> registeredDataSetInfos = registrator.register();
        this.getDataSetInformation().addAll(registeredDataSetInfos);
        return registrator.getMetadataDataSetFile();
    }

    private void registerAnnotatedImages(File registeredMetadataFile) {
        CollectionMetadataExtractor storeReplicaMetadataExtractor = new CollectionMetadataExtractor(registeredMetadataFile);
        storeReplicaMetadataExtractor.prepare();
        for (ImageMetadataExtractor imageMetadataExtractor : storeReplicaMetadataExtractor.getImageMetadataExtractors()) {
            CollectionAnnotatedImagesRegistrator registrator = new CollectionAnnotatedImagesRegistrator(this.globalState, imageMetadataExtractor, this.collectionSample, this.collectionSampleId, this.bundleMetadataDataSetInformation);
            List<DataSetInformation> registeredDataSetInfos = registrator.register();
            this.getDataSetInformation().addAll(registeredDataSetInfos);
        }
    }

    private EntityProperty createProperty(String propertyTypeCode) {
        PropertyType propertyType = new PropertyType();
        DataType dataType = new DataType();
        dataType.setCode(DataTypeCode.VARCHAR);
        propertyType.setCode(propertyTypeCode);
        propertyType.setDataType(dataType);
        EntityProperty property = new EntityProperty();
        property.setPropertyType(propertyType);
        return property;
    }
}

