/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbstractHandler;
import ch.systemsx.cisd.openbis.etlserver.proteomics.IProtDAO;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Experiment;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractSampleHandler
extends AbstractHandler {
    @Private
    static final String MZXML_FILENAME = "MZXML_FILENAME";
    protected final IEncapsulatedOpenBISService openbisService;
    protected final ExperimentIdentifier experimentIdentifier;
    private final Experiment experiment;
    private final Map<String, SampleOrError> samplesOrErrors = new HashMap<String, SampleOrError>();
    private final String delimiter;
    private final boolean restrictedSampleResolving;

    AbstractSampleHandler(IEncapsulatedOpenBISService openbisService, IProtDAO dao, ExperimentIdentifier experimentIdentifier, Experiment experiment, String delimiter, boolean restrictedSampleResolving) {
        super(dao);
        this.openbisService = openbisService;
        this.experimentIdentifier = experimentIdentifier;
        this.experiment = experiment;
        this.delimiter = delimiter;
        this.restrictedSampleResolving = restrictedSampleResolving;
    }

    protected SampleOrError getOrCreateSampleOrError(String sampleNameAndMore) {
        int indexOfDelimiter = sampleNameAndMore.indexOf(this.delimiter);
        String sampleName = indexOfDelimiter < 0 ? sampleNameAndMore : sampleNameAndMore.substring(0, indexOfDelimiter);
        SampleOrError sampleOrError = this.samplesOrErrors.get(sampleName);
        if (sampleOrError == null) {
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)sampleName, (String)"/MS_DATA");
            String sampleCode = sampleIdentifier.getSampleCode();
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample = this.openbisService.tryGetSampleWithExperiment(sampleIdentifier);
            sampleOrError = new SampleOrError();
            if (sample != null) {
                sampleOrError.sample = this.getOrCreateSample(sample.getPermId());
            } else if (!this.restrictedSampleResolving) {
                String spaceCode = this.experimentIdentifier.getSpaceCode();
                List list = this.openbisService.listSamplesByCriteria(new ListSamplesByPropertyCriteria(MZXML_FILENAME, sampleName, spaceCode, null));
                if (list == null || list.size() == 0) {
                    sampleOrError.error = "an unidentified sample: " + sampleName;
                } else if (list.size() > 1) {
                    sampleOrError.error = "a not uniquely specified sample (" + list.size() + " samples are found): " + sampleName;
                } else {
                    sample = (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample)list.get(0);
                    sampleOrError.sample = this.getOrCreateSample(sample.getPermId());
                }
            } else {
                sampleOrError.error = "Couldn't resolve sample: " + sampleIdentifier;
            }
            if (sample != null) {
                this.handleSample(sampleCode, sample);
            }
            this.samplesOrErrors.put(sampleName, sampleOrError);
        }
        return sampleOrError;
    }

    private Sample getOrCreateSample(String samplePermID) {
        Sample sample = this.dao.tryToGetSampleByPermID(samplePermID);
        if (sample == null) {
            sample = new Sample();
            sample.setPermID(samplePermID);
            sample.setId(this.dao.createSample(this.experiment.getId(), samplePermID));
        }
        return sample;
    }

    protected abstract void handleSample(String var1, ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample var2);

    protected static final class SampleOrError {
        Sample sample;
        String error;

        protected SampleOrError() {
        }
    }
}

