/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProbabilityToFDRCalculator {
    private final List<MappingEntry> mappingEntries = new ArrayList<MappingEntry>();

    public void add(double probability, double falseDiscoveryRate) {
        this.mappingEntries.add(new MappingEntry(probability, falseDiscoveryRate));
    }

    public void init() {
        Collections.sort(this.mappingEntries);
    }

    public double calculateFDR(double probability) {
        if (this.mappingEntries.isEmpty()) {
            return Double.NaN;
        }
        int index = Collections.binarySearch(this.mappingEntries, new MappingEntry(probability, 0.0));
        if (index >= 0) {
            return this.mappingEntries.get(index).fdr;
        }
        int index1 = -index - 1;
        int index0 = index1 - 1;
        assert (index0 >= 0);
        MappingEntry m0 = this.mappingEntries.get(index0);
        MappingEntry m1 = this.mappingEntries.get(index1);
        double scale = (m1.fdr - m0.fdr) / (m1.probability - m0.probability);
        return m0.fdr + scale * (probability - m0.probability);
    }

    private static final class MappingEntry
    implements Comparable<MappingEntry> {
        private final double probability;
        private final double fdr;

        MappingEntry(double probability, double fdr) {
            this.probability = probability;
            this.fdr = fdr;
        }

        @Override
        public int compareTo(MappingEntry that) {
            return this.probability < that.probability ? -1 : (this.probability > that.probability ? 1 : 0);
        }

        public String toString() {
            return String.valueOf(this.probability) + " = " + this.fdr;
        }
    }
}

