/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto;

import java.io.Serializable;

public class Treatment
implements Serializable,
Comparable<Treatment> {
    private static final long serialVersionUID = 35L;
    private String value;
    private String type;
    private String typeCode;
    private String valueType;

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final String getValueType() {
        return this.valueType;
    }

    public final void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public final String getType() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public final String getTypeCode() {
        return this.typeCode;
    }

    public final void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public final String getLabel() {
        return String.valueOf(this.value) + " " + this.type;
    }

    @Override
    public int compareTo(Treatment that) {
        int typeComparisonResult = this.type.toLowerCase().compareTo(that.type.toLowerCase());
        if (typeComparisonResult != 0) {
            return typeComparisonResult;
        }
        double thisNumber = this.convert(this.value);
        double thatNumber = this.convert(that.value);
        if (Double.isNaN(thisNumber) || Double.isNaN(thatNumber)) {
            return this.value.compareTo(that.value);
        }
        return Double.compare(thisNumber, thatNumber);
    }

    private double convert(String numberOrString) {
        try {
            return Double.parseDouble(numberOrString);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public String toString() {
        return this.getLabel();
    }
}

